/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.base14.Symbol;
import org.apache.fop.fonts.base14.ZapfDingbats;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class PDFResources
extends PDFDictionary {
    protected Map<String, PDFFont> fonts = new LinkedHashMap<String, PDFFont>();
    protected Set<PDFXObject> xObjects = new LinkedHashSet<PDFXObject>();
    protected Set<PDFPattern> patterns = new LinkedHashSet<PDFPattern>();
    protected Set<PDFShading> shadings = new LinkedHashSet<PDFShading>();
    protected Set<PDFGState> gstates = new LinkedHashSet<PDFGState>();
    protected Map<PDFName, PDFColorSpace> colorSpaces = new LinkedHashMap<PDFName, PDFColorSpace>();
    protected Map<String, PDFICCBasedColorSpace> iccColorSpaces = new LinkedHashMap<String, PDFICCBasedColorSpace>();

    public PDFResources(int n) {
        this.setObjectNumber(n);
    }

    public void addFont(PDFFont pDFFont) {
        this.fonts.put(pDFFont.getName(), pDFFont);
    }

    public void addFonts(PDFDocument pDFDocument, FontInfo fontInfo) {
        Map<String, Typeface> map = fontInfo.getUsedFonts();
        for (String string : map.keySet()) {
            Typeface typeface = map.get(string);
            if (!typeface.hadMappingOperations()) continue;
            FontDescriptor fontDescriptor = null;
            if (typeface instanceof FontDescriptor) {
                fontDescriptor = (FontDescriptor)((Object)typeface);
            }
            String string2 = typeface.getEncodingName();
            if (typeface instanceof Symbol || typeface instanceof ZapfDingbats) {
                string2 = null;
            }
            this.addFont(pDFDocument.getFactory().makeFont(string, typeface.getEmbedFontName(), string2, typeface, fontDescriptor));
        }
    }

    public void addGState(PDFGState pDFGState) {
        this.gstates.add(pDFGState);
    }

    public void addShading(PDFShading pDFShading) {
        this.shadings.add(pDFShading);
    }

    public void addPattern(PDFPattern pDFPattern) {
        this.patterns.add(pDFPattern);
    }

    public void addXObject(PDFXObject pDFXObject) {
        this.xObjects.add(pDFXObject);
    }

    public void addColorSpace(PDFColorSpace pDFColorSpace) {
        this.colorSpaces.put(new PDFName(pDFColorSpace.getName()), pDFColorSpace);
        if (pDFColorSpace instanceof PDFICCBasedColorSpace) {
            PDFICCBasedColorSpace pDFICCBasedColorSpace = (PDFICCBasedColorSpace)pDFColorSpace;
            String string = ColorProfileUtil.getICCProfileDescription((ICC_Profile)pDFICCBasedColorSpace.getICCStream().getICCProfile());
            this.iccColorSpaces.put(string, pDFICCBasedColorSpace);
        }
    }

    public PDFICCBasedColorSpace getICCColorSpaceByProfileName(String string) {
        PDFICCBasedColorSpace pDFICCBasedColorSpace = this.iccColorSpaces.get(string);
        return pDFICCBasedColorSpace;
    }

    public PDFColorSpace getColorSpace(PDFName pDFName) {
        PDFColorSpace pDFColorSpace = this.colorSpaces.get(pDFName);
        return pDFColorSpace;
    }

    public int output(OutputStream outputStream) throws IOException {
        this.populateDictionary();
        return super.output(outputStream);
    }

    private void populateDictionary() {
        Object object;
        PDFObject pDFObject;
        if (!this.fonts.isEmpty()) {
            pDFObject = new PDFDictionary(this);
            for (Map.Entry iterator : this.fonts.entrySet()) {
                ((PDFDictionary)pDFObject).put((String)iterator.getKey(), iterator.getValue());
            }
            this.put("Font", pDFObject);
        }
        if (!this.shadings.isEmpty()) {
            pDFObject = new PDFDictionary(this);
            for (PDFShading pDFShading : this.shadings) {
                ((PDFDictionary)pDFObject).put(pDFShading.getName(), pDFShading);
            }
            this.put("Shading", pDFObject);
        }
        if (!this.patterns.isEmpty()) {
            pDFObject = new PDFDictionary(this);
            for (PDFPattern pDFPattern : this.patterns) {
                ((PDFDictionary)pDFObject).put(pDFPattern.getName(), pDFPattern);
            }
            this.put("Pattern", pDFObject);
        }
        pDFObject = new PDFArray(this);
        ((PDFArray)pDFObject).add(new PDFName("PDF"));
        ((PDFArray)pDFObject).add(new PDFName("ImageB"));
        ((PDFArray)pDFObject).add(new PDFName("ImageC"));
        ((PDFArray)pDFObject).add(new PDFName("Text"));
        this.put("ProcSet", pDFObject);
        if (this.xObjects != null && !this.xObjects.isEmpty()) {
            object = new PDFDictionary(this);
            for (PDFXObject pDFXObject : this.xObjects) {
                ((PDFDictionary)object).put(pDFXObject.getName().toString(), pDFXObject);
            }
            this.put("XObject", object);
        }
        if (!this.gstates.isEmpty()) {
            object = new PDFDictionary(this);
            for (PDFGState pDFGState : this.gstates) {
                ((PDFDictionary)object).put(pDFGState.getName(), pDFGState);
            }
            this.put("ExtGState", object);
        }
        if (!this.colorSpaces.isEmpty()) {
            object = new PDFDictionary(this);
            for (PDFColorSpace pDFColorSpace : this.colorSpaces.values()) {
                ((PDFDictionary)object).put(pDFColorSpace.getName(), pDFColorSpace);
            }
            this.put("ColorSpace", object);
        }
    }
}

