/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.CustomFontCollection;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontInfoConfigurator;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.base14.Base14FontCollection;
import org.apache.fop.render.AbstractRendererConfigurator;
import org.apache.fop.render.DefaultFontResolver;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererConfigurator;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintRendererConfigurator
extends AbstractRendererConfigurator
implements RendererConfigurator,
IFDocumentHandlerConfigurator {
    protected static final Log log = LogFactory.getLog(PrintRendererConfigurator.class);

    public PrintRendererConfigurator(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    @Override
    public void configure(Renderer renderer) throws FOPException {
        Configuration configuration = this.getRendererConfig(renderer);
        if (configuration == null) {
            log.trace((Object)("no configuration found for " + renderer));
            return;
        }
        PrintRenderer printRenderer = (PrintRenderer)renderer;
        FontResolver fontResolver = printRenderer.getFontResolver();
        FontEventAdapter fontEventAdapter = new FontEventAdapter(renderer.getUserAgent().getEventBroadcaster());
        List<EmbedFontInfo> list = this.buildFontList(configuration, fontResolver, fontEventAdapter);
        printRenderer.addFontList(list);
    }

    protected List<EmbedFontInfo> buildFontList(Configuration configuration, FontResolver fontResolver, FontEventListener fontEventListener) throws FOPException {
        FopFactory fopFactory = this.userAgent.getFactory();
        FontManager fontManager = fopFactory.getFontManager();
        if (fontResolver == null) {
            fontResolver = FontManager.createMinimalFontResolver(this.userAgent.isComplexScriptFeaturesEnabled());
        }
        boolean bl = fopFactory.validateUserConfigStrictly();
        FontInfoConfigurator fontInfoConfigurator = new FontInfoConfigurator(configuration, fontManager, fontResolver, fontEventListener, bl);
        ArrayList<EmbedFontInfo> arrayList = new ArrayList<EmbedFontInfo>();
        fontInfoConfigurator.configure(arrayList);
        return arrayList;
    }

    @Override
    public void configure(IFDocumentHandler iFDocumentHandler) throws FOPException {
    }

    @Override
    public void setupFontInfo(IFDocumentHandler iFDocumentHandler, FontInfo fontInfo) throws FOPException {
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        ArrayList<FontCollection> arrayList = new ArrayList<FontCollection>();
        arrayList.add(new Base14FontCollection(fontManager.isBase14KerningEnabled()));
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            DefaultFontResolver defaultFontResolver = new DefaultFontResolver(this.userAgent);
            FontEventAdapter fontEventAdapter = new FontEventAdapter(this.userAgent.getEventBroadcaster());
            List<EmbedFontInfo> list = this.buildFontList(configuration, defaultFontResolver, fontEventAdapter);
            arrayList.add(new CustomFontCollection(defaultFontResolver, list, this.userAgent.isComplexScriptFeaturesEnabled()));
        }
        fontManager.setup(fontInfo, arrayList.toArray(new FontCollection[arrayList.size()]));
        iFDocumentHandler.setFontInfo(fontInfo);
    }
}

