/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.AFPResourceLevelDefaults;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.AFPFontCollection;
import org.apache.fop.afp.fonts.AFPFontInfo;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.CharacterSetBuilder;
import org.apache.fop.afp.fonts.CharacterSetType;
import org.apache.fop.afp.fonts.DoubleByteFont;
import org.apache.fop.afp.fonts.OutlineFont;
import org.apache.fop.afp.fonts.RasterFont;
import org.apache.fop.afp.util.DefaultFOPResourceAccessor;
import org.apache.fop.afp.util.ResourceAccessor;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.afp.AFPCustomizable;
import org.apache.fop.render.afp.AFPDocumentHandler;
import org.apache.fop.render.afp.AFPShadingMode;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.util.LogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFPRendererConfigurator
extends PrintRendererConfigurator
implements IFDocumentHandlerConfigurator {
    private final AFPEventProducer eventProducer;
    private static final String IMAGES_MODE_GRAYSCALE = "b+w";
    private static final String IMAGES_MODE_COLOR = "color";

    public AFPRendererConfigurator(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
        this.eventProducer = AFPEventProducer.Provider.get(fOUserAgent.getEventBroadcaster());
    }

    private AFPFontInfo buildFont(Configuration configuration, String string) throws ConfigurationException {
        Object object;
        Object object22;
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        Configuration[] configurationArray = configuration.getChildren("font-triplet");
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        if (configurationArray.length == 0) {
            this.eventProducer.fontConfigMissing(this, "<font-triplet...", configuration.getLocation());
            return null;
        }
        for (Object object22 : configurationArray) {
            int n = FontUtil.parseCSS2FontWeight(object22.getAttribute("weight"));
            object = new FontTriplet(object22.getAttribute("name"), object22.getAttribute("style"), n);
            arrayList.add((FontTriplet)object);
        }
        Configuration[] configurationArray2 = configuration.getChildren("afp-font");
        if (configurationArray2.length == 0) {
            this.eventProducer.fontConfigMissing(this, "<afp-font...", configuration.getLocation());
            return null;
        }
        Configuration configuration2 = configurationArray2[0];
        URI uRI = null;
        object22 = configuration2.getAttribute("base-uri", string);
        if (object22 == null) {
            String string2 = configuration2.getAttribute("path", string);
            if (string2 != null) {
                object = new File(string2);
                uRI = ((File)object).toURI();
            }
        } else {
            try {
                uRI = new URI((String)object22);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.eventProducer.invalidConfiguration(this, uRISyntaxException);
                return null;
            }
        }
        DefaultFOPResourceAccessor defaultFOPResourceAccessor = new DefaultFOPResourceAccessor(this.userAgent, fontManager.getFontBaseURL(), uRI);
        object = null;
        try {
            String string3 = configuration2.getAttribute("type");
            if (string3 == null) {
                this.eventProducer.fontConfigMissing(this, "type attribute", configuration.getLocation());
                return null;
            }
            String string4 = configuration2.getAttribute("codepage");
            if (string4 == null) {
                this.eventProducer.fontConfigMissing(this, "codepage attribute", configuration.getLocation());
                return null;
            }
            String string5 = configuration2.getAttribute("encoding");
            if (string5 == null) {
                this.eventProducer.fontConfigMissing(this, "encoding attribute", configuration.getLocation());
                return null;
            }
            object = this.fontFromType(string3, string4, string5, defaultFOPResourceAccessor, configuration2);
        }
        catch (ConfigurationException configurationException) {
            this.eventProducer.invalidConfiguration(this, (Exception)((Object)configurationException));
        }
        catch (IOException iOException) {
            this.eventProducer.invalidConfiguration(this, iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.eventProducer.invalidConfiguration(this, illegalArgumentException);
        }
        return object != null ? new AFPFontInfo((AFPFont)object, (List<FontTriplet>)arrayList) : null;
    }

    private AFPFont fontFromType(String string, String string2, String string3, ResourceAccessor resourceAccessor, Configuration configuration) throws ConfigurationException, IOException {
        if ("raster".equalsIgnoreCase(string)) {
            String string4 = configuration.getAttribute("name", "Unknown");
            RasterFont rasterFont = new RasterFont(string4);
            Configuration[] configurationArray = configuration.getChildren("afp-raster-font");
            if (configurationArray.length == 0) {
                this.eventProducer.fontConfigMissing(this, "<afp-raster-font...", configuration.getLocation());
                return null;
            }
            for (int i = 0; i < configurationArray.length; ++i) {
                Configuration configuration2 = configurationArray[i];
                String string5 = configuration2.getAttribute("characterset");
                if (string5 == null) {
                    this.eventProducer.fontConfigMissing(this, "characterset attribute", configuration.getLocation());
                    return null;
                }
                float f = configuration2.getAttributeAsFloat("size");
                int n = (int)(f * 1000.0f);
                String string6 = configuration2.getAttribute("base14-font", null);
                if (string6 != null) {
                    Object object;
                    try {
                        Class<Typeface> clazz = Class.forName("org.apache.fop.fonts.base14." + string6).asSubclass(Typeface.class);
                        try {
                            object = clazz.newInstance();
                            rasterFont.addCharacterSet(n, CharacterSetBuilder.getSingleByteInstance().build(string5, string2, string3, (Typeface)object, this.eventProducer));
                        }
                        catch (Exception exception) {
                            String string7 = "The base 14 font class " + clazz.getName() + " could not be instantiated";
                            log.error((Object)string7);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        object = "The base 14 font class for " + string5 + " could not be found";
                        log.error(object);
                    }
                    continue;
                }
                rasterFont.addCharacterSet(n, CharacterSetBuilder.getSingleByteInstance().buildSBCS(string5, string2, string3, resourceAccessor, this.eventProducer));
            }
            return rasterFont;
        }
        if ("outline".equalsIgnoreCase(string)) {
            String string8 = configuration.getAttribute("characterset");
            if (string8 == null) {
                this.eventProducer.fontConfigMissing(this, "characterset attribute", configuration.getLocation());
                return null;
            }
            String string9 = configuration.getAttribute("name", string8);
            CharacterSet characterSet = null;
            String string10 = configuration.getAttribute("base14-font", null);
            if (string10 != null) {
                try {
                    Class<Typeface> clazz = Class.forName("org.apache.fop.fonts.base14." + string10).asSubclass(Typeface.class);
                    try {
                        Typeface typeface = clazz.newInstance();
                        characterSet = CharacterSetBuilder.getSingleByteInstance().build(string8, string2, string3, typeface, this.eventProducer);
                    }
                    catch (Exception exception) {
                        String string11 = "The base 14 font class " + clazz.getName() + " could not be instantiated";
                        log.error((Object)string11);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string12 = "The base 14 font class for " + string8 + " could not be found";
                    log.error((Object)string12);
                }
            } else {
                characterSet = CharacterSetBuilder.getSingleByteInstance().buildSBCS(string8, string2, string3, resourceAccessor, this.eventProducer);
            }
            return new OutlineFont(string9, characterSet);
        }
        if ("CIDKeyed".equalsIgnoreCase(string)) {
            String string13 = configuration.getAttribute("characterset");
            if (string13 == null) {
                this.eventProducer.fontConfigMissing(this, "characterset attribute", configuration.getLocation());
                return null;
            }
            String string14 = configuration.getAttribute("name", string13);
            CharacterSet characterSet = null;
            CharacterSetType characterSetType = configuration.getAttributeAsBoolean("ebcdic-dbcs", false) ? CharacterSetType.DOUBLE_BYTE_LINE_DATA : CharacterSetType.DOUBLE_BYTE;
            characterSet = CharacterSetBuilder.getDoubleByteInstance().buildDBCS(string13, string2, string3, characterSetType, resourceAccessor, this.eventProducer);
            DoubleByteFont doubleByteFont = new DoubleByteFont(string14, characterSet);
            return doubleByteFont;
        }
        log.error((Object)("No or incorrect type attribute: " + string));
        return null;
    }

    private List<AFPFontInfo> buildFontListFromConfiguration(Configuration configuration, AFPEventProducer aFPEventProducer) throws FOPException, ConfigurationException {
        Configuration configuration2 = configuration.getChild("fonts");
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        FontTriplet.Matcher matcher = fontManager.getReferencedFontsMatcher();
        FontTriplet.Matcher matcher2 = null;
        Configuration configuration3 = configuration2.getChild("referenced-fonts", false);
        if (configuration3 != null) {
            matcher2 = FontManagerConfigurator.createFontsMatcher(configuration3, this.userAgent.getFactory().validateUserConfigStrictly());
        }
        ArrayList<AFPFontInfo> arrayList = new ArrayList<AFPFontInfo>();
        Configuration[] configurationArray = configuration2.getChildren("font");
        String string = null;
        for (int i = 0; i < configurationArray.length; ++i) {
            AFPFontInfo aFPFontInfo = this.buildFont(configurationArray[i], string);
            if (aFPFontInfo == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding font " + aFPFontInfo.getAFPFont().getFontName()));
            }
            List<FontTriplet> list = aFPFontInfo.getFontTriplets();
            for (int j = 0; j < list.size(); ++j) {
                FontTriplet fontTriplet = list.get(j);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Font triplet " + fontTriplet.getName() + ", " + fontTriplet.getStyle() + ", " + fontTriplet.getWeight()));
                }
                if ((matcher == null || !matcher.matches(fontTriplet)) && (matcher2 == null || !matcher2.matches(fontTriplet))) continue;
                aFPFontInfo.getAFPFont().setEmbeddable(false);
                break;
            }
            arrayList.add(aFPFontInfo);
        }
        return arrayList;
    }

    @Override
    public void configure(Renderer renderer) {
        throw new UnsupportedOperationException();
    }

    private void configure(AFPCustomizable aFPCustomizable, Configuration configuration) throws FOPException {
        Object object;
        Object object2;
        Configuration configuration2;
        Configuration configuration3;
        int n;
        Configuration configuration4 = configuration.getChild("images");
        String string = configuration4.getAttribute("mode", IMAGES_MODE_GRAYSCALE);
        if (IMAGES_MODE_COLOR.equals(string)) {
            aFPCustomizable.setColorImages(true);
            n = configuration4.getAttributeAsBoolean("cmyk", false);
            aFPCustomizable.setCMYKImagesSupported(n != 0);
        } else {
            aFPCustomizable.setColorImages(false);
            n = configuration4.getAttributeAsInteger("bits-per-pixel", 8);
            aFPCustomizable.setBitsPerPixel(n);
        }
        String string2 = configuration4.getAttribute("dithering-quality", "medium");
        float f = 0.5f;
        if (string2.startsWith("min")) {
            f = 0.0f;
        } else if (string2.startsWith("max")) {
            f = 1.0f;
        } else {
            try {
                f = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        aFPCustomizable.setDitheringQuality(f);
        boolean bl = configuration4.getAttributeAsBoolean("native", false);
        aFPCustomizable.setNativeImagesSupported(bl);
        Configuration configuration5 = configuration4.getChild("jpeg");
        boolean bl2 = false;
        float f2 = 1.0f;
        if (configuration5 != null) {
            bl2 = configuration5.getAttributeAsBoolean("allow-embedding", false);
            String string3 = configuration5.getAttribute("bitmap-encoding-quality", null);
            if (string3 != null) {
                try {
                    f2 = Float.parseFloat(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        aFPCustomizable.canEmbedJpeg(bl2);
        aFPCustomizable.setBitmapEncodingQuality(f2);
        boolean bl3 = configuration4.getAttributeAsBoolean("pseg", false);
        aFPCustomizable.setWrapPSeg(bl3);
        boolean bl4 = configuration4.getAttributeAsBoolean("fs45", false);
        aFPCustomizable.setFS45(bl4);
        Configuration configuration6 = configuration.getChild("shading");
        AFPShadingMode aFPShadingMode = AFPShadingMode.valueOf(configuration6.getValue(AFPShadingMode.COLOR.getName()));
        aFPCustomizable.setShadingMode(aFPShadingMode);
        Configuration configuration7 = configuration.getChild("goca");
        boolean bl5 = configuration7.getAttributeAsBoolean("enabled", aFPCustomizable.isGOCAEnabled());
        aFPCustomizable.setGOCAEnabled(bl5);
        String string4 = configuration7.getAttribute("text", aFPCustomizable.isStrokeGOCAText() ? "stroke" : "default");
        aFPCustomizable.setStrokeGOCAText("stroke".equalsIgnoreCase(string4) || "shapes".equalsIgnoreCase(string4));
        Configuration configuration8 = configuration.getChild("renderer-resolution", false);
        if (configuration8 != null) {
            aFPCustomizable.setResolution(configuration8.getValueAsInteger(240));
        }
        if ((configuration3 = configuration.getChild("line-width-correction", false)) != null) {
            aFPCustomizable.setLineWidthCorrection(configuration3.getValueAsFloat(2.5f));
        }
        if ((configuration2 = configuration.getChild("resource-group-file", false)) != null) {
            object2 = null;
            try {
                object2 = configuration2.getValue();
                if (object2 != null) {
                    object = new File((String)object2);
                    boolean bl6 = ((File)object).createNewFile();
                    if (bl6 && ((File)object).canWrite()) {
                        aFPCustomizable.setDefaultResourceGroupFilePath((String)object2);
                    } else {
                        log.warn((Object)("Unable to write to default external resource group file '" + (String)object2 + "'"));
                    }
                }
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(log, (Exception)((Object)configurationException), this.userAgent.getFactory().validateUserConfigStrictly());
            }
            catch (IOException iOException) {
                throw new FOPException("Could not create default external resource group file", iOException);
            }
        }
        if ((object2 = configuration.getChild("default-resource-levels", false)) != null) {
            object = new AFPResourceLevelDefaults();
            for (String string5 : object2.getAttributeNames()) {
                try {
                    String string6 = object2.getAttribute(string5);
                    ((AFPResourceLevelDefaults)object).setDefaultResourceLevel(string5, AFPResourceLevel.valueOf(string6));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LogUtil.handleException(log, illegalArgumentException, this.userAgent.getFactory().validateUserConfigStrictly());
                }
                catch (ConfigurationException configurationException) {
                    LogUtil.handleException(log, (Exception)((Object)configurationException), this.userAgent.getFactory().validateUserConfigStrictly());
                }
            }
            aFPCustomizable.setResourceLevelDefaults((AFPResourceLevelDefaults)object);
        }
    }

    @Override
    public void configure(IFDocumentHandler iFDocumentHandler) throws FOPException {
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            AFPDocumentHandler aFPDocumentHandler = (AFPDocumentHandler)iFDocumentHandler;
            this.configure(aFPDocumentHandler, configuration);
        }
    }

    @Override
    public void setupFontInfo(IFDocumentHandler iFDocumentHandler, FontInfo fontInfo) throws FOPException {
        FontManager fontManager = this.userAgent.getFactory().getFontManager();
        ArrayList<AFPFontCollection> arrayList = new ArrayList<AFPFontCollection>();
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            try {
                List<AFPFontInfo> list = this.buildFontListFromConfiguration(configuration, this.eventProducer);
                arrayList.add(new AFPFontCollection(this.userAgent.getEventBroadcaster(), list));
            }
            catch (ConfigurationException configurationException) {
                this.eventProducer.invalidConfiguration(this, (Exception)((Object)configurationException));
                LogUtil.handleException(log, (Exception)((Object)configurationException), this.userAgent.getFactory().validateUserConfigStrictly());
            }
        } else {
            arrayList.add(new AFPFontCollection(this.userAgent.getEventBroadcaster(), null));
        }
        fontManager.setup(fontInfo, arrayList.toArray(new FontCollection[arrayList.size()]));
        iFDocumentHandler.setFontInfo(fontInfo);
    }
}

