/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.IOException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.awt.viewer.PreviewDialog;
import org.apache.fop.render.awt.viewer.Renderable;
import org.apache.fop.render.awt.viewer.StatusListener;
import org.apache.fop.render.extensions.prepress.PageScale;
import org.apache.fop.render.java2d.Java2DRenderer;

public class AWTRenderer
extends Java2DRenderer
implements Pageable {
    public static final String MIME_TYPE = "application/X-fop-awt-preview";
    public boolean debug;
    protected StatusListener statusListener = null;

    public AWTRenderer(FOUserAgent fOUserAgent) {
        this(fOUserAgent, null, false, false);
    }

    public AWTRenderer(FOUserAgent fOUserAgent, Renderable renderable, boolean bl, boolean bl2) {
        super(fOUserAgent);
        if (bl2) {
            this.setStatusListener(PreviewDialog.createPreviewDialog(fOUserAgent, renderable, bl));
        }
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        super.renderPage(pageViewport);
        if (this.statusListener != null) {
            this.statusListener.notifyPageRendered();
        }
    }

    public void stopRenderer() throws IOException {
        super.stopRenderer();
        if (this.statusListener != null) {
            this.statusListener.notifyRendererStopped();
        }
    }

    public Dimension getPageImageSize(int n) throws FOPException {
        String string;
        Point2D point2D;
        Rectangle rectangle = this.getPageViewport(n).getViewArea();
        this.pageWidth = (int)Math.round(((RectangularShape)rectangle).getWidth() / 1000.0);
        this.pageHeight = (int)Math.round(((RectangularShape)rectangle).getHeight() / 1000.0);
        double d = this.scaleFactor * 0.35277777910232544 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
        double d2 = this.scaleFactor * 0.35277777910232544 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
        if (this.getPageViewport(n).getForeignAttributes() != null && (point2D = PageScale.getScale(string = this.getPageViewport(n).getForeignAttributes().get(PageScale.EXT_PAGE_SCALE))) != null) {
            d *= point2D.getX();
            d2 *= point2D.getY();
        }
        int n2 = (int)((double)this.pageWidth * d + 0.5);
        int n3 = (int)((double)this.pageHeight * d2 + 0.5);
        return new Dimension(n2, n3);
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        try {
            double d;
            if (n >= this.getNumberOfPages()) {
                return null;
            }
            PageFormat pageFormat = new PageFormat();
            Paper paper = new Paper();
            Rectangle rectangle = this.getPageViewport(n).getViewArea();
            double d2 = ((RectangularShape)rectangle).getWidth();
            if (d2 > (d = ((RectangularShape)rectangle).getHeight())) {
                paper.setImageableArea(0.0, 0.0, d / 1000.0, d2 / 1000.0);
                paper.setSize(d / 1000.0, d2 / 1000.0);
                pageFormat.setOrientation(0);
            } else {
                paper.setImageableArea(0.0, 0.0, d2 / 1000.0, d / 1000.0);
                paper.setSize(d2 / 1000.0, d / 1000.0);
                pageFormat.setOrientation(1);
            }
            pageFormat.setPaper(paper);
            return pageFormat;
        }
        catch (FOPException fOPException) {
            throw new IndexOutOfBoundsException(fOPException.getMessage());
        }
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public boolean supportsOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    protected void drawBackAndBorders(Area area, float f, float f2, float f3, float f4) {
        if (this.debug) {
            this.debugBackAndBorders(area, f, f2, f3, f4);
        }
        super.drawBackAndBorders(area, f, f2, f3, f4);
    }

    private void debugBackAndBorders(Area area, float f, float f2, float f3, float f4) {
        this.saveGraphicsState();
        Color color = new Color(0.7f, 0.7f, 0.7f);
        this.state.updateColor(color);
        this.state.updateStroke(0.4f, 133);
        this.state.getGraph().draw(new Rectangle2D.Float(f, f2, f3, f4));
        this.restoreGraphicsState();
    }

    public StatusListener getStatusListener() {
        return this.statusListener;
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }
}

