/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.bitmap.BitmapRendererEventProducer;
import org.apache.fop.render.bitmap.MultiFileRenderingUtil;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;

public class PNGRenderer
extends Java2DRenderer {
    public static final String MIME_TYPE = "image/png";
    private static final String PNG_FILE_EXTENSION = "png";
    private OutputStream firstOutputStream;
    private MultiFileRenderingUtil multiFileUtil;

    public PNGRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.info((Object)"rendering areas to PNG");
        this.multiFileUtil = new MultiFileRenderingUtil(PNG_FILE_EXTENSION, this.getUserAgent().getOutputFile());
        this.firstOutputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRenderer() throws IOException {
        super.stopRenderer();
        for (int i = 0; i < this.pageViewportList.size(); ++i) {
            Object object;
            OutputStream outputStream = this.getCurrentOutputStream(i);
            if (outputStream == null) {
                object = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                object.stoppingAfterFirstPageNoFilename(this);
                break;
            }
            try {
                object = (PageViewport)this.pageViewportList.get(i);
                BufferedImage bufferedImage = this.getPageImage((PageViewport)object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Encoding page " + (i + 1)));
                }
                this.writeImage(outputStream, bufferedImage);
                continue;
            }
            finally {
                if (outputStream != this.firstOutputStream) {
                    IOUtils.closeQuietly((OutputStream)outputStream);
                }
            }
        }
    }

    private void writeImage(OutputStream outputStream, RenderedImage renderedImage) throws IOException {
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        imageWriterParams.setResolution(Math.round(this.userAgent.getTargetResolution()));
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
        if (imageWriter == null) {
            BitmapRendererEventProducer bitmapRendererEventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            bitmapRendererEventProducer.noImageWriterFound(this, this.getMimeType());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing image using " + imageWriter.getClass().getName()));
        }
        imageWriter.writeImage(renderedImage, outputStream, imageWriterParams);
    }

    protected OutputStream getCurrentOutputStream(int n) throws IOException {
        if (n == 0) {
            return this.firstOutputStream;
        }
        return this.multiFileUtil.createOutputStream(n);
    }
}

