/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.render.ImageHandlerRegistry;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.w3c.dom.Document;

public abstract class AbstractIFPainter
implements IFPainter {
    private static Log log = LogFactory.getLog(AbstractIFPainter.class);
    protected static final String INSTREAM_OBJECT_URI = "(instream-object)";
    protected IFState state;

    protected abstract IFContext getContext();

    protected FOUserAgent getUserAgent() {
        return this.getContext().getUserAgent();
    }

    protected FopFactory getFopFactory() {
        return this.getUserAgent().getFactory();
    }

    private AffineTransform combine(AffineTransform[] affineTransformArray) {
        AffineTransform affineTransform = new AffineTransform();
        int n = affineTransformArray.length;
        for (int i = 0; i < n; ++i) {
            affineTransform.concatenate(affineTransformArray[i]);
        }
        return affineTransform;
    }

    public void startViewport(AffineTransform[] affineTransformArray, Dimension dimension, Rectangle rectangle) throws IFException {
        this.startViewport(this.combine(affineTransformArray), dimension, rectangle);
    }

    public void startGroup(AffineTransform[] affineTransformArray) throws IFException {
        this.startGroup(this.combine(affineTransformArray));
    }

    protected abstract RenderingContext createRenderingContext();

    protected void drawImageUsingImageHandler(ImageInfo imageInfo, Rectangle rectangle) throws ImageException, IOException {
        ImageManager imageManager = this.getFopFactory().getImageManager();
        ImageSessionContext imageSessionContext = this.getUserAgent().getImageSessionContext();
        ImageHandlerRegistry imageHandlerRegistry = this.getFopFactory().getImageHandlerRegistry();
        RenderingContext renderingContext = this.createRenderingContext();
        Map map = this.createDefaultImageProcessingHints(imageSessionContext);
        renderingContext.putHints(map);
        ImageFlavor[] imageFlavorArray = imageHandlerRegistry.getSupportedFlavors(renderingContext);
        Image image = imageManager.getImage(imageInfo, imageFlavorArray, map, imageSessionContext);
        try {
            this.drawImage(image, rectangle, renderingContext);
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageWritingError(this, iOException);
        }
    }

    protected Map createDefaultImageProcessingHints(ImageSessionContext imageSessionContext) {
        Map map = ImageUtil.getDefaultHints((ImageSessionContext)imageSessionContext);
        Object object = this.getContext().getForeignAttribute(ImageHandlerUtil.CONVERSION_MODE);
        if (object != null) {
            map.put(ImageHandlerUtil.CONVERSION_MODE, object);
        }
        return map;
    }

    protected void drawImage(Image image, Rectangle rectangle, RenderingContext renderingContext) throws IOException, ImageException {
        this.drawImage(image, rectangle, renderingContext, false, null);
    }

    protected void drawImage(Image image, Rectangle rectangle, RenderingContext renderingContext, boolean bl, Map map) throws IOException, ImageException {
        Image image2;
        Object object;
        ImageManager imageManager = this.getFopFactory().getImageManager();
        ImageHandlerRegistry imageHandlerRegistry = this.getFopFactory().getImageHandlerRegistry();
        renderingContext.putHints(map);
        if (bl) {
            object = this.createDefaultImageProcessingHints(this.getUserAgent().getImageSessionContext());
            if (map != null) {
                object.putAll(map);
            }
            image2 = imageManager.convertImage(image, imageHandlerRegistry.getSupportedFlavors(renderingContext), (Map)object);
        } else {
            image2 = image;
        }
        object = imageHandlerRegistry.getHandler(renderingContext, image2);
        if (object == null) {
            throw new UnsupportedOperationException("No ImageHandler available for image: " + image2.getInfo() + " (" + image2.getClass().getName() + ")");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Using ImageHandler: " + object.getClass().getName()));
        }
        object.handleImage(renderingContext, image2, rectangle);
    }

    protected ImageInfo getImageInfo(String string) {
        ImageManager imageManager = this.getFopFactory().getImageManager();
        try {
            ImageSessionContext imageSessionContext = this.getUserAgent().getImageSessionContext();
            return imageManager.getImageInfo(string, imageSessionContext);
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError(this, string, imageException, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageNotFound(this, string, fileNotFoundException, null);
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageIOError(this, string, iOException, null);
        }
        return null;
    }

    protected void drawImageUsingURI(String string, Rectangle rectangle) {
        ImageManager imageManager = this.getFopFactory().getImageManager();
        ImageInfo imageInfo = null;
        try {
            ImageSessionContext imageSessionContext = this.getUserAgent().getImageSessionContext();
            imageInfo = imageManager.getImageInfo(string, imageSessionContext);
            this.drawImageUsingImageHandler(imageInfo, rectangle);
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError(this, imageInfo != null ? imageInfo.toString() : string, imageException, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageNotFound(this, imageInfo != null ? imageInfo.toString() : string, fileNotFoundException, null);
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageIOError(this, imageInfo != null ? imageInfo.toString() : string, iOException, null);
        }
    }

    protected void drawImageUsingDocument(Document document, Rectangle rectangle) {
        ImageManager imageManager = this.getFopFactory().getImageManager();
        ImageInfo imageInfo = null;
        try {
            imageInfo = imageManager.preloadImage(null, (Source)new DOMSource(document));
            this.drawImageUsingImageHandler(imageInfo, rectangle);
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError(this, imageInfo != null ? imageInfo.toString() : INSTREAM_OBJECT_URI, imageException, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageNotFound(this, imageInfo != null ? imageInfo.toString() : INSTREAM_OBJECT_URI, fileNotFoundException, null);
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageIOError(this, imageInfo != null ? imageInfo.toString() : INSTREAM_OBJECT_URI, iOException, null);
        }
    }

    public void drawBorderRect(Rectangle rectangle, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) throws IFException {
        Rectangle rectangle2;
        if (borderProps != null) {
            rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, borderProps.width);
            this.fillRect(rectangle2, borderProps.color);
        }
        if (borderProps4 != null) {
            rectangle2 = new Rectangle(rectangle.x + rectangle.width - borderProps4.width, rectangle.y, borderProps4.width, rectangle.height);
            this.fillRect(rectangle2, borderProps4.color);
        }
        if (borderProps2 != null) {
            rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - borderProps2.width, rectangle.width, borderProps2.width);
            this.fillRect(rectangle2, borderProps2.color);
        }
        if (borderProps3 != null) {
            rectangle2 = new Rectangle(rectangle.x, rectangle.y, borderProps3.width, rectangle.height);
            this.fillRect(rectangle2, borderProps3.color);
        }
    }

    protected boolean hasOnlySolidBorders(BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) {
        if (borderProps != null && borderProps.style != 133) {
            return false;
        }
        if (borderProps2 != null && borderProps2.style != 133) {
            return false;
        }
        if (borderProps3 != null && borderProps3.style != 133) {
            return false;
        }
        return borderProps4 == null || borderProps4.style == 133;
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) throws IFException {
        Rectangle rectangle = this.getLineBoundingBox(point, point2, n);
        this.fillRect(rectangle, color);
    }

    protected Rectangle getLineBoundingBox(Point point, Point point2, int n) {
        if (point.y == point2.y) {
            int n2 = point.y - n / 2;
            return new Rectangle(point.x, n2, point2.x - point.x, n);
        }
        if (point.x == point2.y) {
            int n3 = point.x - n / 2;
            return new Rectangle(n3, point.x, n, point2.y - point.y);
        }
        throw new IllegalArgumentException("Only horizontal or vertical lines are supported at the moment.");
    }

    public void setFont(String string, String string2, Integer n, String string3, Integer n2, Color color) throws IFException {
        if (string != null) {
            this.state.setFontFamily(string);
        }
        if (string2 != null) {
            this.state.setFontStyle(string2);
        }
        if (n != null) {
            this.state.setFontWeight(n);
        }
        if (string3 != null) {
            this.state.setFontVariant(string3);
        }
        if (n2 != null) {
            this.state.setFontSize(n2);
        }
        if (color != null) {
            this.state.setTextColor(color);
        }
    }

    public static AffineTransform toPoints(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        dArray[4] = dArray[4] / 1000.0;
        dArray[5] = dArray[5] / 1000.0;
        return new AffineTransform(dArray);
    }
}

