/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.extensions.prepress.PageBoundaries;
import org.apache.fop.render.extensions.prepress.PageScale;
import org.apache.fop.render.java2d.Base14FontCollection;
import org.apache.fop.render.java2d.ConfiguredFontCollection;
import org.apache.fop.render.java2d.InstalledFontCollection;
import org.apache.fop.render.java2d.Java2DFontMetrics;
import org.apache.fop.render.java2d.Java2DGraphics2DAdapter;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public abstract class Java2DRenderer
extends AbstractPathOrientedRenderer
implements Printable {
    public static final String JAVA2D_TRANSPARENT_PAGE_BACKGROUND = "transparent-page-background";
    protected double scaleFactor = 1.0;
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected List pageViewportList = new ArrayList();
    private int currentPageNumber = 0;
    protected boolean antialiasing = true;
    protected boolean qualityRendering = true;
    protected boolean transparentPageBackground = false;
    protected Java2DGraphicsState state;
    private final Stack stateStack = new Stack();
    private boolean renderingDone;
    private GeneralPath currentPath = null;
    private static final ImageFlavor[] FLAVOURS = new ImageFlavor[]{ImageFlavor.GRAPHICS2D, ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE, ImageFlavor.XML_DOM};

    public Java2DRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
        fOUserAgent.setRendererOverride(this);
        String string = (String)fOUserAgent.getRendererOptions().get(JAVA2D_TRANSPARENT_PAGE_BACKGROUND);
        if (string != null) {
            this.transparentPageBackground = "true".equalsIgnoreCase(string);
        }
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setupFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
        Java2DFontMetrics java2DFontMetrics = new Java2DFontMetrics();
        FontCollection[] fontCollectionArray = new FontCollection[]{new Base14FontCollection(java2DFontMetrics), new InstalledFontCollection(java2DFontMetrics), new ConfiguredFontCollection(this.getFontResolver(), this.getFontList(), this.userAgent.isComplexScriptFeaturesEnabled())};
        this.userAgent.getFactory().getFontManager().setup(this.getFontInfo(), fontCollectionArray);
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new Java2DGraphics2DAdapter();
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        super.startRenderer(outputStream);
    }

    public void stopRenderer() throws IOException {
        log.debug((Object)"Java2DRenderer stopped");
        this.renderingDone = true;
        int n = this.currentPageNumber;
        if (n == 0) {
            new FOPException("No page could be rendered");
        }
    }

    public boolean isRenderingDone() {
        return this.renderingDone;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setCurrentPageNumber(int n) {
        this.currentPageNumber = n;
    }

    public int getNumberOfPages() {
        return this.pageViewportList.size();
    }

    public void clearViewportList() {
        this.pageViewportList.clear();
        this.setCurrentPageNumber(0);
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        try {
            this.rememberPage((PageViewport)pageViewport.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FOPException(cloneNotSupportedException);
        }
        ++this.currentPageNumber;
    }

    protected void rememberPage(PageViewport pageViewport) {
        assert (pageViewport.getPageIndex() >= 0);
        this.pageViewportList.add(pageViewport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getPageImage(PageViewport pageViewport) {
        this.currentPageViewport = pageViewport;
        try {
            PageBoundaries pageBoundaries = new PageBoundaries(pageViewport.getViewArea().getSize(), pageViewport.getForeignAttributes());
            Rectangle rectangle = pageBoundaries.getCropBox();
            Rectangle rectangle2 = pageBoundaries.getBleedBox();
            this.pageWidth = (int)Math.round(rectangle.getWidth() / 1000.0);
            this.pageHeight = (int)Math.round(rectangle.getHeight() / 1000.0);
            log.info((Object)("Rendering Page " + pageViewport.getPageNumberString() + " (pageWidth " + this.pageWidth + ", pageHeight " + this.pageHeight + ")"));
            double d = this.scaleFactor;
            double d2 = this.scaleFactor;
            String string = this.currentPageViewport.getForeignAttributes().get(PageScale.EXT_PAGE_SCALE);
            Point2D point2D = PageScale.getScale(string);
            if (point2D != null) {
                d *= point2D.getX();
                d2 *= point2D.getY();
            }
            d = d * 0.35277777910232544 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
            d2 = d2 * 0.35277777910232544 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
            int n = (int)((double)this.pageWidth * d + 0.5);
            int n2 = (int)((double)this.pageHeight * d2 + 0.5);
            BufferedImage bufferedImage = this.getBufferedImage(n, n2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            if (this.antialiasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (this.qualityRendering) {
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            AffineTransform affineTransform = graphics2D.getTransform();
            affineTransform.scale(d, d2);
            affineTransform.translate(rectangle.getMinX() / -1000.0, rectangle.getMinY() / -1000.0);
            graphics2D.setTransform(affineTransform);
            if (!this.transparentPageBackground) {
                graphics2D.setColor(Color.white);
                graphics2D.fillRect((int)Math.round(rectangle2.getMinX() / 1000.0), (int)Math.round(rectangle2.getMinY() / 1000.0), (int)Math.round(rectangle2.getWidth() / 1000.0), (int)Math.round(rectangle2.getHeight() / 1000.0));
            }
            this.state = new Java2DGraphicsState(graphics2D, this.fontInfo, affineTransform);
            try {
                this.currentBPPosition = 0;
                this.currentIPPosition = 0;
                this.renderPageAreas(pageViewport.getPage());
            }
            finally {
                this.state = null;
            }
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            this.currentPageViewport = null;
        }
    }

    protected BufferedImage getBufferedImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    public PageViewport getPageViewport(int n) throws FOPException {
        if (n < 0 || n >= this.pageViewportList.size()) {
            throw new FOPException("Requested page number is out of range: " + n + "; only " + this.pageViewportList.size() + " page(s) available.");
        }
        return (PageViewport)this.pageViewportList.get(n);
    }

    public BufferedImage getPageImage(int n) throws FOPException {
        return this.getPageImage(this.getPageViewport(n));
    }

    protected void saveGraphicsState() {
        this.stateStack.push(this.state);
        this.state = new Java2DGraphicsState(this.state);
    }

    protected void restoreGraphicsState() {
        this.state.dispose();
        this.state = (Java2DGraphicsState)this.stateStack.pop();
    }

    protected void concatenateTransformationMatrix(AffineTransform affineTransform) {
        this.state.transform(affineTransform);
    }

    protected void startVParea(CTM cTM, Rectangle rectangle) {
        this.saveGraphicsState();
        if (rectangle != null) {
            this.clipRect((float)rectangle.getX() / 1000.0f, (float)rectangle.getY() / 1000.0f, (float)rectangle.getWidth() / 1000.0f, (float)rectangle.getHeight() / 1000.0f);
        }
        this.state.transform(new AffineTransform(CTMHelper.toPDFArray(cTM)));
    }

    protected void endVParea() {
        this.restoreGraphicsState();
    }

    protected List breakOutOfStateStack() {
        log.debug((Object)"Block.FIXED --> break out");
        ArrayList<Java2DGraphicsState> arrayList = new ArrayList<Java2DGraphicsState>();
        while (!this.stateStack.isEmpty()) {
            arrayList.add(0, this.state);
            this.state = (Java2DGraphicsState)this.stateStack.pop();
        }
        return arrayList;
    }

    protected void restoreStateStackAfterBreakOut(List list) {
        log.debug((Object)"Block.FIXED --> restoring context after break-out");
        for (Java2DGraphicsState java2DGraphicsState : list) {
            this.stateStack.push(this.state);
            this.state = java2DGraphicsState;
        }
    }

    protected void updateColor(Color color, boolean bl) {
        this.state.updateColor(color);
    }

    protected void clip() {
        if (this.currentPath == null) {
            throw new IllegalStateException("No current path available!");
        }
        this.state.updateClip(this.currentPath);
        this.currentPath = null;
    }

    protected void closePath() {
        this.currentPath.closePath();
    }

    protected void lineTo(float f, float f2) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.lineTo(f, f2);
    }

    protected void moveTo(float f, float f2) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.moveTo(f, f2);
    }

    protected void clipRect(float f, float f2, float f3, float f4) {
        this.state.updateClip(new Rectangle2D.Float(f, f2, f3, f4));
    }

    protected void fillRect(float f, float f2, float f3, float f4) {
        this.state.getGraph().fill(new Rectangle2D.Float(f, f2, f3, f4));
    }

    protected void drawBorderLine(float f, float f2, float f3, float f4, boolean bl, boolean bl2, int n, Color color) {
        Graphics2D graphics2D = this.state.getGraph();
        float f5 = f3 - f;
        float f6 = f4 - f2;
        Java2DRenderer.drawBorderLine(new Rectangle2D.Float(f, f2, f5, f6), bl, bl2, n, color, graphics2D);
    }

    public static void drawBorderLine(Rectangle2D.Float float_, boolean bl, boolean bl2, int n, Color color, Graphics2D graphics2D) {
        float f = float_.x;
        float f2 = float_.y;
        float f3 = f + float_.width;
        float f4 = f2 + float_.height;
        float f5 = float_.width;
        float f6 = float_.height;
        if (f5 < 0.0f || f6 < 0.0f) {
            log.error((Object)"Negative extent received. Border won't be painted.");
            return;
        }
        switch (n) {
            case 31: {
                graphics2D.setColor(color);
                if (bl) {
                    float f7 = Math.abs(2.0f * f6);
                    int n2 = (int)(f5 / f7);
                    if (n2 % 2 == 0) {
                        ++n2;
                    }
                    f7 = f5 / (float)n2;
                    float f8 = f2 + f6 / 2.0f;
                    BasicStroke basicStroke = new BasicStroke(f6, 0, 0, 10.0f, new float[]{f7}, 0.0f);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.draw(new Line2D.Float(f, f8, f3, f8));
                    break;
                }
                float f9 = Math.abs(2.0f * f5);
                int n3 = (int)(f6 / f9);
                if (n3 % 2 == 0) {
                    ++n3;
                }
                f9 = f6 / (float)n3;
                float f10 = f + f5 / 2.0f;
                BasicStroke basicStroke = new BasicStroke(f5, 0, 0, 10.0f, new float[]{f9}, 0.0f);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw(new Line2D.Float(f10, f2, f10, f4));
                break;
            }
            case 36: {
                graphics2D.setColor(color);
                if (bl) {
                    float f11 = Math.abs(2.0f * f6);
                    int n4 = (int)(f5 / f11);
                    if (n4 % 2 == 0) {
                        ++n4;
                    }
                    f11 = f5 / (float)n4;
                    float f12 = f2 + f6 / 2.0f;
                    BasicStroke basicStroke = new BasicStroke(f6, 1, 0, 10.0f, new float[]{0.0f, f11}, 0.0f);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.draw(new Line2D.Float(f, f12, f3, f12));
                    break;
                }
                float f13 = Math.abs(2.0f * f5);
                int n5 = (int)(f6 / f13);
                if (n5 % 2 == 0) {
                    ++n5;
                }
                f13 = f6 / (float)n5;
                float f14 = f + f5 / 2.0f;
                BasicStroke basicStroke = new BasicStroke(f5, 1, 0, 10.0f, new float[]{0.0f, f13}, 0.0f);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw(new Line2D.Float(f14, f2, f14, f4));
                break;
            }
            case 37: {
                graphics2D.setColor(color);
                if (bl) {
                    float f15 = f6 / 3.0f;
                    float f16 = f2 + f15 / 2.0f;
                    float f17 = f16 + f15 + f15;
                    BasicStroke basicStroke = new BasicStroke(f15);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.draw(new Line2D.Float(f, f16, f3, f16));
                    graphics2D.draw(new Line2D.Float(f, f17, f3, f17));
                    break;
                }
                float f18 = f5 / 3.0f;
                float f19 = f + f18 / 2.0f;
                float f20 = f19 + f18 + f18;
                BasicStroke basicStroke = new BasicStroke(f18);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw(new Line2D.Float(f19, f2, f19, f4));
                graphics2D.draw(new Line2D.Float(f20, f2, f20, f4));
                break;
            }
            case 55: 
            case 119: {
                float f21;
                float f22 = f21 = n == 55 ? 0.4f : -0.4f;
                if (bl) {
                    Color color2 = ColorUtil.lightenColor(color, -f21);
                    Color color3 = ColorUtil.lightenColor(color, f21);
                    float f23 = f6 / 3.0f;
                    float f24 = f2 + f23 / 2.0f;
                    graphics2D.setStroke(new BasicStroke(f23));
                    graphics2D.setColor(color2);
                    graphics2D.draw(new Line2D.Float(f, f24, f3, f24));
                    graphics2D.setColor(color);
                    graphics2D.draw(new Line2D.Float(f, f24 + f23, f3, f24 + f23));
                    graphics2D.setColor(color3);
                    graphics2D.draw(new Line2D.Float(f, f24 + f23 + f23, f3, f24 + f23 + f23));
                    break;
                }
                Color color4 = ColorUtil.lightenColor(color, -f21);
                Color color5 = ColorUtil.lightenColor(color, f21);
                float f25 = f5 / 3.0f;
                float f26 = f + f25 / 2.0f;
                graphics2D.setStroke(new BasicStroke(f25));
                graphics2D.setColor(color4);
                graphics2D.draw(new Line2D.Float(f26, f2, f26, f4));
                graphics2D.setColor(color);
                graphics2D.draw(new Line2D.Float(f26 + f25, f2, f26 + f25, f4));
                graphics2D.setColor(color5);
                graphics2D.draw(new Line2D.Float(f26 + f25 + f25, f2, f26 + f25 + f25, f4));
                break;
            }
            case 67: 
            case 101: {
                float f27;
                float f28 = f27 = n == 101 ? 0.4f : -0.4f;
                if (bl) {
                    color = ColorUtil.lightenColor(color, (float)(bl2 ? 1 : -1) * f27);
                    graphics2D.setStroke(new BasicStroke(f6));
                    float f29 = f2 + f6 / 2.0f;
                    graphics2D.setColor(color);
                    graphics2D.draw(new Line2D.Float(f, f29, f3, f29));
                    break;
                }
                color = ColorUtil.lightenColor(color, (float)(bl2 ? 1 : -1) * f27);
                float f30 = f + f5 / 2.0f;
                graphics2D.setStroke(new BasicStroke(f5));
                graphics2D.setColor(color);
                graphics2D.draw(new Line2D.Float(f30, f2, f30, f4));
                break;
            }
            case 57: {
                break;
            }
            default: {
                graphics2D.setColor(color);
                if (bl) {
                    float f31 = f2 + f6 / 2.0f;
                    graphics2D.setStroke(new BasicStroke(f6));
                    graphics2D.draw(new Line2D.Float(f, f31, f3, f31));
                    break;
                }
                float f32 = f + f5 / 2.0f;
                graphics2D.setStroke(new BasicStroke(f5));
                graphics2D.draw(new Line2D.Float(f32, f2, f32, f4));
            }
        }
    }

    public void renderText(TextArea textArea) {
        this.renderInlineAreaBackAndBorders(textArea);
        int n = this.currentIPPosition + textArea.getBorderAndPaddingWidthStart();
        int n2 = this.currentBPPosition + textArea.getBlockProgressionOffset() + textArea.getBaselineOffset();
        int n3 = this.currentIPPosition;
        Font font = this.getFontFromArea(textArea);
        this.state.updateFont(font.getFontName(), font.getFontSize());
        this.saveGraphicsState();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate((float)n / 1000.0f, (float)n2 / 1000.0f);
        this.state.transform(affineTransform);
        Java2DRenderer.renderText(textArea, this.state.getGraph(), font);
        this.restoreGraphicsState();
        this.currentIPPosition = n3 + textArea.getAllocIPD();
        Typeface typeface = this.fontInfo.getFonts().get(font.getFontName());
        int n4 = textArea.getTraitAsInteger(Trait.FONT_SIZE);
        this.renderTextDecoration(typeface, n4, textArea, n2, n);
    }

    public static void renderText(TextArea textArea, Graphics2D graphics2D, Font font) {
        Color color = (Color)textArea.getTrait(Trait.COLOR);
        graphics2D.setColor(color);
        float f = 0.0f;
        for (InlineArea inlineArea : textArea.getChildAreas()) {
            String string;
            InlineArea inlineArea2;
            if (inlineArea instanceof WordArea) {
                inlineArea2 = (WordArea)inlineArea;
                string = ((WordArea)inlineArea2).getWord();
                int[] nArray = ((WordArea)inlineArea2).getLetterAdjustArray();
                GlyphVector glyphVector = graphics2D.getFont().createGlyphVector(graphics2D.getFontRenderContext(), string);
                double d = 0.0;
                if (nArray != null || textArea.getTextLetterSpaceAdjust() != 0 || textArea.getTextWordSpaceAdjust() != 0) {
                    int[] nArray2 = Java2DRenderer.getGlyphOffsets(string, font, textArea, nArray);
                    float f2 = 0.0f;
                    for (int i = 0; i < nArray2.length; ++i) {
                        Point2D point2D = glyphVector.getGlyphPosition(i);
                        point2D.setLocation(f2, point2D.getY());
                        glyphVector.setGlyphPosition(i, point2D);
                        f2 += (float)nArray2[i] / 1000.0f;
                    }
                    d = (double)f2 - glyphVector.getLogicalBounds().getWidth();
                }
                graphics2D.drawGlyphVector(glyphVector, f, 0.0f);
                f = (float)((double)f + (glyphVector.getLogicalBounds().getWidth() + d));
                continue;
            }
            if (inlineArea instanceof SpaceArea) {
                inlineArea2 = (SpaceArea)inlineArea;
                string = ((SpaceArea)inlineArea2).getSpace();
                char c = string.charAt(0);
                int n = ((SpaceArea)inlineArea2).isAdjustable() ? textArea.getTextWordSpaceAdjust() + 2 * textArea.getTextLetterSpaceAdjust() : 0;
                f += (float)(font.getCharWidth(c) + n) / 1000.0f;
                continue;
            }
            throw new IllegalStateException("Unsupported child element: " + inlineArea);
        }
    }

    private static int[] getGlyphOffsets(String string, Font font, TextArea textArea, int[] nArray) {
        int n = string.length();
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = font.mapChar(c);
            int n2 = CharUtilities.isAdjustableSpace(c2) ? textArea.getTextWordSpaceAdjust() : 0;
            int n3 = font.getWidth(c2);
            int n4 = nArray != null && i < n - 1 ? nArray[i + 1] : 0;
            int n5 = i < n - 1 ? textArea.getTextLetterSpaceAdjust() : 0;
            nArray2[i] = n3 + n4 + n5 + n2;
        }
        return nArray2;
    }

    public void renderLeader(Leader leader) {
        this.renderInlineAreaBackAndBorders(leader);
        float f = (float)(this.currentIPPosition + leader.getBorderAndPaddingWidthStart()) / 1000.0f;
        float f2 = (float)(this.currentBPPosition + leader.getBlockProgressionOffset()) / 1000.0f;
        float f3 = (float)(this.currentIPPosition + leader.getBorderAndPaddingWidthStart() + leader.getIPD()) / 1000.0f;
        Color color = (Color)leader.getTrait(Trait.COLOR);
        this.state.updateColor(color);
        Line2D.Float float_ = new Line2D.Float();
        ((Line2D)float_).setLine(f, f2, f3, f2);
        float f4 = (float)leader.getRuleThickness() / 1000.0f;
        int n = leader.getRuleStyle();
        switch (n) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(f, f2, f3, f2 + f4, true, true, n, color);
                break;
            }
            case 36: {
                this.state.updateStroke(f4, n);
                float f5 = f4 / 2.0f;
                ((Line2D)float_).setLine(((Line2D)float_).getX1(), ((Line2D)float_).getY1() + (double)f5, ((Line2D)float_).getX2(), ((Line2D)float_).getY2() + (double)f5);
                this.state.getGraph().draw(float_);
                break;
            }
            case 55: 
            case 119: {
                float f6 = (float)leader.getRuleThickness() / 2000.0f;
                this.state.updateColor(ColorUtil.lightenColor(color, 0.6f));
                this.moveTo(f, f2);
                this.lineTo(f3, f2);
                this.lineTo(f3, f2 + 2.0f * f6);
                this.lineTo(f, f2 + 2.0f * f6);
                this.closePath();
                this.state.getGraph().fill(this.currentPath);
                this.currentPath = null;
                this.state.updateColor(color);
                if (n == 55) {
                    this.moveTo(f, f2);
                    this.lineTo(f3, f2);
                    this.lineTo(f3, f2 + f6);
                    this.lineTo(f + f6, f2 + f6);
                    this.lineTo(f, f2 + 2.0f * f6);
                } else {
                    this.moveTo(f3, f2);
                    this.lineTo(f3, f2 + 2.0f * f6);
                    this.lineTo(f, f2 + 2.0f * f6);
                    this.lineTo(f, f2 + f6);
                    this.lineTo(f3 - f6, f2 + f6);
                }
                this.closePath();
                this.state.getGraph().fill(this.currentPath);
                this.currentPath = null;
            }
            case 95: {
                break;
            }
        }
        super.renderLeader(leader);
    }

    public void renderImage(Image image, Rectangle2D rectangle2D) {
        String string = image.getURL();
        this.drawImage(string, rectangle2D);
    }

    protected void drawImage(String string, Rectangle2D rectangle2D, Map map) {
        int n = this.currentIPPosition + (int)Math.round(rectangle2D.getX());
        int n2 = this.currentBPPosition + (int)Math.round(rectangle2D.getY());
        string = URISpecification.getURL(string);
        ImageManager imageManager = this.getUserAgent().getFactory().getImageManager();
        ImageInfo imageInfo = null;
        try {
            ImageSessionContext imageSessionContext = this.getUserAgent().getImageSessionContext();
            imageInfo = imageManager.getImageInfo(string, imageSessionContext);
            Map map2 = ImageUtil.getDefaultHints((ImageSessionContext)imageSessionContext);
            org.apache.xmlgraphics.image.loader.Image image = imageManager.getImage(imageInfo, FLAVOURS, map2, imageSessionContext);
            if (image instanceof ImageGraphics2D) {
                ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
                int n3 = (int)rectangle2D.getWidth();
                int n4 = (int)rectangle2D.getHeight();
                RendererContext rendererContext = this.createRendererContext(n, n2, n3, n4, map);
                this.getGraphics2DAdapter().paintImage(imageGraphics2D.getGraphics2DImagePainter(), rendererContext, n, n2, n3, n4);
            } else if (image instanceof ImageRendered) {
                ImageRendered imageRendered = (ImageRendered)image;
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate((float)n / 1000.0f, (float)n2 / 1000.0f);
                double d = rectangle2D.getWidth() / (double)imageInfo.getSize().getWidthMpt();
                double d2 = rectangle2D.getHeight() / (double)imageInfo.getSize().getHeightMpt();
                affineTransform.scale(d *= (double)this.userAgent.getSourceResolution() / imageInfo.getSize().getDpiHorizontal(), d2 *= (double)this.userAgent.getSourceResolution() / imageInfo.getSize().getDpiVertical());
                this.state.getGraph().drawRenderedImage(imageRendered.getRenderedImage(), affineTransform);
            } else if (image instanceof ImageXMLDOM) {
                ImageXMLDOM imageXMLDOM = (ImageXMLDOM)image;
                this.renderDocument(imageXMLDOM.getDocument(), imageXMLDOM.getRootNamespace(), rectangle2D, map);
            }
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError(this, imageInfo != null ? imageInfo.toString() : string, imageException, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageNotFound(this, imageInfo != null ? imageInfo.toString() : string, fileNotFoundException, null);
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageIOError(this, imageInfo != null ? imageInfo.toString() : string, iOException, null);
        }
    }

    protected RendererContext createRendererContext(int n, int n2, int n3, int n4, Map map) {
        RendererContext rendererContext = super.createRendererContext(n, n2, n3, n4, map);
        rendererContext.setProperty("state", this.state);
        return rendererContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.getNumberOfPages()) {
            return 1;
        }
        if (this.state != null) {
            throw new IllegalStateException("state must be null");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        try {
            PageViewport pageViewport = this.getPageViewport(n);
            AffineTransform affineTransform = graphics2D.getTransform();
            this.state = new Java2DGraphicsState(graphics2D, this.fontInfo, affineTransform);
            this.currentBPPosition = 0;
            this.currentIPPosition = 0;
            this.renderPageAreas(pageViewport.getPage());
            int n2 = 0;
            return n2;
        }
        catch (FOPException fOPException) {
            log.error((Object)fOPException);
            int n3 = 1;
            return n3;
        }
        finally {
            this.state = null;
        }
    }

    protected void beginTextObject() {
    }

    protected void endTextObject() {
    }

    public void setTransparentPageBackground(boolean bl) {
        this.transparentPageBackground = bl;
    }
}

