/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.java2d.FontMetricsMapper;
import org.apache.fop.render.java2d.Java2DPainter;
import org.apache.fop.render.pcl.HardcodedFonts;
import org.apache.fop.render.pcl.PCLConstants;
import org.apache.fop.render.pcl.PCLDocumentHandler;
import org.apache.fop.render.pcl.PCLGenerator;
import org.apache.fop.render.pcl.PCLPageDefinition;
import org.apache.fop.render.pcl.PCLRenderingContext;
import org.apache.fop.render.pcl.PCLRenderingMode;
import org.apache.fop.render.pcl.PCLRenderingUtil;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.w3c.dom.Document;

public class PCLPainter
extends AbstractIFPainter
implements PCLConstants {
    private static final boolean DEBUG = false;
    private PCLDocumentHandler parent;
    private PCLGenerator gen;
    private PCLPageDefinition currentPageDefinition;
    private int currentPrintDirection = 0;
    private Stack graphicContextStack = new Stack();
    private GraphicContext graphicContext = new GraphicContext();
    private static final double SAFETY_MARGIN_FACTOR = 0.05;

    public PCLPainter(PCLDocumentHandler pCLDocumentHandler, PCLPageDefinition pCLPageDefinition) {
        this.parent = pCLDocumentHandler;
        this.gen = pCLDocumentHandler.getPCLGenerator();
        this.state = IFState.create();
        this.currentPageDefinition = pCLPageDefinition;
    }

    public IFContext getContext() {
        return this.parent.getContext();
    }

    PCLRenderingUtil getPCLUtil() {
        return this.parent.getPCLUtil();
    }

    protected int getResolution() {
        int n = Math.round(this.getUserAgent().getTargetResolution());
        if (n <= 300) {
            return 300;
        }
        return 600;
    }

    private boolean isSpeedOptimized() {
        return this.getPCLUtil().getRenderingMode() == PCLRenderingMode.SPEED;
    }

    public void startViewport(AffineTransform affineTransform, Dimension dimension, Rectangle rectangle) throws IFException {
        this.saveGraphicsState();
        try {
            this.concatenateTransformationMatrix(affineTransform);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startViewport()", iOException);
        }
    }

    public void endViewport() throws IFException {
        this.restoreGraphicsState();
    }

    public void startGroup(AffineTransform affineTransform) throws IFException {
        this.saveGraphicsState();
        try {
            this.concatenateTransformationMatrix(affineTransform);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startGroup()", iOException);
        }
    }

    public void endGroup() throws IFException {
        this.restoreGraphicsState();
    }

    public void drawImage(String string, Rectangle rectangle) throws IFException {
        this.drawImageUsingURI(string, rectangle);
    }

    protected RenderingContext createRenderingContext() {
        PCLRenderingContext pCLRenderingContext = new PCLRenderingContext(this.getUserAgent(), this.gen, this.getPCLUtil()){

            public Point2D transformedPoint(int n, int n2) {
                return PCLPainter.this.transformedPoint(n, n2);
            }

            public GraphicContext getGraphicContext() {
                return PCLPainter.this.graphicContext;
            }
        };
        return pCLRenderingContext;
    }

    public void drawImage(Document document, Rectangle rectangle) throws IFException {
        this.drawImageUsingDocument(document, rectangle);
    }

    public void clipRect(Rectangle rectangle) throws IFException {
    }

    public void fillRect(Rectangle rectangle, Paint paint) throws IFException {
        if (paint == null) {
            return;
        }
        if (rectangle.width != 0 && rectangle.height != 0) {
            Color color = null;
            if (paint != null) {
                if (!(paint instanceof Color)) {
                    throw new UnsupportedOperationException("Non-Color paints NYI");
                }
                color = (Color)paint;
                try {
                    this.setCursorPos(rectangle.x, rectangle.y);
                    this.gen.fillRect(rectangle.width, rectangle.height, color);
                }
                catch (IOException iOException) {
                    throw new IFException("I/O error in fillRect()", iOException);
                }
            }
        }
    }

    public void drawBorderRect(final Rectangle rectangle, final BorderProps borderProps, final BorderProps borderProps2, final BorderProps borderProps3, final BorderProps borderProps4) throws IFException {
        if (this.isSpeedOptimized()) {
            super.drawBorderRect(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
            return;
        }
        if (borderProps != null || borderProps2 != null || borderProps3 != null || borderProps4 != null) {
            Rectangle rectangle2 = rectangle;
            final Dimension dimension = rectangle2.getSize();
            Graphics2DImagePainter graphics2DImagePainter = new Graphics2DImagePainter(){

                public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
                    graphics2D.translate(-rectangle.x, -rectangle.y);
                    Java2DPainter java2DPainter = new Java2DPainter(graphics2D, PCLPainter.this.getContext(), PCLPainter.this.parent.getFontInfo(), PCLPainter.this.state);
                    try {
                        java2DPainter.drawBorderRect(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
                    }
                    catch (IFException iFException) {
                        throw new RuntimeException("Unexpected error while painting borders", iFException);
                    }
                }

                public Dimension getImageSize() {
                    return dimension.getSize();
                }
            };
            this.paintMarksAsBitmap(graphics2DImagePainter, rectangle2);
        }
    }

    public void drawLine(final Point point, final Point point2, final int n, final Color color, final RuleStyle ruleStyle) throws IFException {
        if (this.isSpeedOptimized()) {
            super.drawLine(point, point2, n, color, ruleStyle);
            return;
        }
        final Rectangle rectangle = this.getLineBoundingBox(point, point2, n);
        final Dimension dimension = rectangle.getSize();
        Graphics2DImagePainter graphics2DImagePainter = new Graphics2DImagePainter(){

            public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
                graphics2D.translate(-rectangle.x, -rectangle.y);
                Java2DPainter java2DPainter = new Java2DPainter(graphics2D, PCLPainter.this.getContext(), PCLPainter.this.parent.getFontInfo(), PCLPainter.this.state);
                try {
                    java2DPainter.drawLine(point, point2, n, color, ruleStyle);
                }
                catch (IFException iFException) {
                    throw new RuntimeException("Unexpected error while painting a line", iFException);
                }
            }

            public Dimension getImageSize() {
                return dimension.getSize();
            }
        };
        this.paintMarksAsBitmap(graphics2DImagePainter, rectangle);
    }

    private void paintMarksAsBitmap(Graphics2DImagePainter graphics2DImagePainter, Rectangle rectangle) throws IFException {
        ImageInfo imageInfo = new ImageInfo(null, null);
        ImageSize imageSize = new ImageSize();
        imageSize.setSizeInMillipoints(rectangle.width, rectangle.height);
        imageInfo.setSize(imageSize);
        ImageGraphics2D imageGraphics2D = new ImageGraphics2D(imageInfo, graphics2DImagePainter);
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        if (this.isSpeedOptimized()) {
            hashMap.put(ImageProcessingHints.BITMAP_TYPE_INTENT, "mono");
        } else {
            hashMap.put(ImageProcessingHints.BITMAP_TYPE_INTENT, "gray");
        }
        hashMap.put(ImageHandlerUtil.CONVERSION_MODE, "bitmap");
        PCLRenderingContext pCLRenderingContext = (PCLRenderingContext)this.createRenderingContext();
        pCLRenderingContext.setSourceTransparencyEnabled(true);
        try {
            this.drawImage((Image)imageGraphics2D, rectangle, pCLRenderingContext, true, hashMap);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error while painting marks using a bitmap", iOException);
        }
        catch (ImageException imageException) {
            throw new IFException("Error while painting marks using a bitmap", (Exception)((Object)imageException));
        }
    }

    public void drawText(int n, int n2, int n3, int n4, int[][] nArray, String string) throws IFException {
        try {
            boolean bl;
            FontTriplet fontTriplet = new FontTriplet(this.state.getFontFamily(), this.state.getFontStyle(), this.state.getFontWeight());
            String string2 = this.parent.getFontInfo().getInternalFontKey(fontTriplet);
            boolean bl2 = bl = this.getPCLUtil().isAllTextAsBitmaps() ? false : HardcodedFonts.setFont(this.gen, string2, this.state.getFontSize(), string);
            if (bl) {
                this.drawTextNative(n, n2, n3, n4, nArray, string, fontTriplet);
            } else {
                this.drawTextAsBitmap(n, n2, n3, n4, nArray, string, fontTriplet);
            }
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in drawText()", iOException);
        }
    }

    private void drawTextNative(int n, int n2, int n3, int n4, int[][] nArray, String string, FontTriplet fontTriplet) throws IOException {
        Color color = this.state.getTextColor();
        if (color != null) {
            this.gen.setTransparencyMode(true, false);
            this.gen.selectGrayscale(color);
        }
        this.gen.setTransparencyMode(true, true);
        this.setCursorPos(n, n2);
        float f = (float)this.state.getFontSize() / 1000.0f;
        Font font = this.parent.getFontInfo().getFontInstance(fontTriplet, this.state.getFontSize());
        int n5 = string.length();
        int[] nArray2 = IFUtil.convertDPToDX(nArray);
        int n6 = nArray2 != null ? nArray2.length : 0;
        StringBuffer stringBuffer = new StringBuffer(Math.max(16, n5));
        if (nArray2 != null && n6 > 0 && nArray2[0] != 0) {
            stringBuffer.append("\u001b&a+").append(this.gen.formatDouble2((double)nArray2[0] / 100.0)).append('H');
        }
        for (int i = 0; i < n5; ++i) {
            char c;
            char c2 = string.charAt(i);
            float f2 = 0.0f;
            if (font.hasChar(c2)) {
                c = font.mapChar(c2);
            } else if (CharUtilities.isFixedWidthSpace(c2)) {
                c = font.mapChar(' ');
                int n7 = font.getCharWidth(c) - font.getCharWidth(c2);
                f2 = -((float)(10 * n7) / f);
            } else {
                c = font.mapChar(c2);
            }
            stringBuffer.append(c);
            if (n4 != 0 && CharUtilities.isAdjustableSpace(c2)) {
                f2 += (float)n4;
            }
            f2 += (float)n3;
            if (nArray2 != null && i < n6 - 1) {
                f2 += (float)nArray2[i + 1];
            }
            if (f2 == 0.0f) continue;
            stringBuffer.append("\u001b&a+").append(this.gen.formatDouble2((double)f2 / 100.0)).append('H');
        }
        this.gen.getOutputStream().write(stringBuffer.toString().getBytes(this.gen.getTextEncoding()));
    }

    private Rectangle getTextBoundingBox(int n, int n2, int n3, int n4, int[][] nArray, String string, Font font, FontMetricsMapper fontMetricsMapper) {
        int n5;
        int n6;
        int n7 = fontMetricsMapper.getMaxAscent(font.getFontSize()) / 1000;
        int n8 = fontMetricsMapper.getDescender(font.getFontSize()) / 1000;
        int n9 = (int)(0.05 * (double)font.getFontSize());
        Rectangle rectangle = new Rectangle(n, n2 - n7 - n9, 0, n7 - n8 + 2 * n9);
        int n10 = string.length();
        int[] nArray2 = IFUtil.convertDPToDX(nArray);
        int n11 = n6 = nArray2 != null ? nArray2.length : 0;
        if (nArray2 != null && n6 > 0 && nArray2[0] != 0) {
            rectangle.setLocation(rectangle.x - (int)Math.ceil((float)nArray2[0] / 10.0f), rectangle.y);
        }
        float f = 0.0f;
        for (n5 = 0; n5 < n10; ++n5) {
            char c = string.charAt(n5);
            float f2 = 0.0f;
            int n12 = font.getCharWidth(c);
            if (n4 != 0 && CharUtilities.isAdjustableSpace(c)) {
                f2 += (float)n4;
            }
            f2 += (float)n3;
            if (nArray2 != null && n5 < n6 - 1) {
                f2 += (float)nArray2[n5 + 1];
            }
            f += (float)n12 + f2;
        }
        n5 = font.getFontSize() / 3;
        rectangle.setSize((int)Math.ceil(f) + n5, rectangle.height);
        return rectangle;
    }

    private void drawTextAsBitmap(final int n, final int n2, final int n3, final int n4, final int[][] nArray, final String string, FontTriplet fontTriplet) throws IFException {
        Font font = this.parent.getFontInfo().getFontInstance(fontTriplet, this.state.getFontSize());
        FontMetricsMapper fontMetricsMapper = (FontMetricsMapper)this.parent.getFontInfo().getMetricsFor(font.getFontName());
        final int n5 = fontMetricsMapper.getMaxAscent(font.getFontSize()) / 1000;
        final int n6 = fontMetricsMapper.getAscender(font.getFontSize()) / 1000;
        final int n7 = fontMetricsMapper.getDescender(font.getFontSize()) / 1000;
        int n8 = (int)(0.05 * (double)font.getFontSize());
        final int n9 = n5 + n8;
        Rectangle rectangle = this.getTextBoundingBox(n, n2, n3, n4, nArray, string, font, fontMetricsMapper);
        final Dimension dimension = rectangle.getSize();
        Graphics2DImagePainter graphics2DImagePainter = new Graphics2DImagePainter(){

            public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
                graphics2D.translate(-n, -n2 + n9);
                Java2DPainter java2DPainter = new Java2DPainter(graphics2D, PCLPainter.this.getContext(), PCLPainter.this.parent.getFontInfo(), PCLPainter.this.state);
                try {
                    java2DPainter.drawText(n, n2, n3, n4, nArray, string);
                }
                catch (IFException iFException) {
                    throw new RuntimeException("Unexpected error while painting text", iFException);
                }
            }

            public Dimension getImageSize() {
                return dimension.getSize();
            }
        };
        this.paintMarksAsBitmap(graphics2DImagePainter, rectangle);
    }

    private void saveGraphicsState() {
        this.graphicContextStack.push(this.graphicContext);
        this.graphicContext = (GraphicContext)this.graphicContext.clone();
    }

    private void restoreGraphicsState() {
        this.graphicContext = (GraphicContext)this.graphicContextStack.pop();
    }

    private void concatenateTransformationMatrix(AffineTransform affineTransform) throws IOException {
        if (!affineTransform.isIdentity()) {
            this.graphicContext.transform(affineTransform);
            this.changePrintDirection();
        }
    }

    private Point2D transformedPoint(int n, int n2) {
        return PCLRenderingUtil.transformedPoint(n, n2, this.graphicContext.getTransform(), this.currentPageDefinition, this.currentPrintDirection);
    }

    private void changePrintDirection() throws IOException {
        AffineTransform affineTransform = this.graphicContext.getTransform();
        int n = PCLRenderingUtil.determinePrintDirection(affineTransform);
        if (n != this.currentPrintDirection) {
            this.currentPrintDirection = n;
            this.gen.changePrintDirection(this.currentPrintDirection);
        }
    }

    void setCursorPos(int n, int n2) throws IOException {
        Point2D point2D = this.transformedPoint(n, n2);
        this.gen.setCursorPos(point2D.getX(), point2D.getY());
    }
}

