/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.render.AbstractGenericSVGHandler;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.PDFRendererContextConstants;

public class PDFSVGHandler
extends AbstractGenericSVGHandler
implements PDFRendererContextConstants {
    private static Log log = LogFactory.getLog(PDFSVGHandler.class);

    public static PDFInfo getPDFInfo(RendererContext rendererContext) {
        PDFInfo pDFInfo = new PDFInfo();
        pDFInfo.pdfDoc = (PDFDocument)rendererContext.getProperty("pdfDoc");
        pDFInfo.outputStream = (OutputStream)rendererContext.getProperty("outputStream");
        pDFInfo.pdfPage = (PDFPage)rendererContext.getProperty("pdfPage");
        pDFInfo.pdfContext = (PDFResourceContext)rendererContext.getProperty("pdfContext");
        pDFInfo.width = (Integer)rendererContext.getProperty("width");
        pDFInfo.height = (Integer)rendererContext.getProperty("height");
        pDFInfo.fi = (FontInfo)rendererContext.getProperty("fontInfo");
        pDFInfo.currentFontName = (String)rendererContext.getProperty("fontName");
        pDFInfo.currentFontSize = (Integer)rendererContext.getProperty("fontSize");
        pDFInfo.currentXPosition = (Integer)rendererContext.getProperty("xpos");
        pDFInfo.currentYPosition = (Integer)rendererContext.getProperty("ypos");
        pDFInfo.cfg = (Configuration)rendererContext.getProperty("cfg");
        Map map = (Map)rendererContext.getProperty("foreign-attributes");
        pDFInfo.paintAsBitmap = ImageHandlerUtil.isConversionModeBitmap(map);
        return pDFInfo;
    }

    public boolean supportsRenderer(Renderer renderer) {
        return false;
    }

    public static class PDFInfo {
        public PDFDocument pdfDoc;
        public OutputStream outputStream;
        public PDFPage pdfPage;
        public PDFResourceContext pdfContext;
        public int width;
        public int height;
        public FontInfo fi;
        public String currentFontName;
        public int currentFontSize;
        public int currentXPosition;
        public int currentYPosition;
        public Configuration cfg;
        public boolean paintAsBitmap;
    }
}

