/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.render.pdf.extensions.AbstractPDFExtensionElement;
import org.apache.fop.render.pdf.extensions.PDFEmbeddedFileExtensionAttachment;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class PDFEmbeddedFileElement
extends AbstractPDFExtensionElement {
    protected static final String ELEMENT = "embedded-file";

    protected PDFEmbeddedFileElement(FONode fONode) {
        super(fONode);
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        if (this.parent.getNameId() != 13) {
            this.invalidChildError(this.getLocator(), this.parent.getName(), this.getNamespaceURI(), this.getName(), "rule.childOfDeclarations");
        }
    }

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        PDFEmbeddedFileExtensionAttachment pDFEmbeddedFileExtensionAttachment = (PDFEmbeddedFileExtensionAttachment)this.getExtensionAttachment();
        String string2 = attributes.getValue("description");
        if (string2 != null && string2.length() > 0) {
            pDFEmbeddedFileExtensionAttachment.setDesc(string2);
        }
        String string3 = attributes.getValue("src");
        if ((string3 = URISpecification.getURL(string3)) != null && string3.length() > 0) {
            pDFEmbeddedFileExtensionAttachment.setSrc(string3);
        } else {
            this.missingPropertyError("src");
        }
        String string4 = attributes.getValue("filename");
        if (string4 == null || string4.length() == 0) {
            try {
                URI uRI = new URI(string3);
                String string5 = uRI.getPath();
                int n = string5.lastIndexOf(47);
                string4 = n > 0 ? string5.substring(n + 1) : string5;
                pDFEmbeddedFileExtensionAttachment.setFilename(string4);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.missingPropertyError("name");
            }
        }
        pDFEmbeddedFileExtensionAttachment.setFilename(string4);
    }

    public String getLocalName() {
        return ELEMENT;
    }

    protected ExtensionAttachment instantiateExtensionAttachment() {
        return new PDFEmbeddedFileExtensionAttachment();
    }
}

