/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.ps.NativeTextHandler;
import org.apache.fop.render.ps.PSBridgeContext;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.TextHandler;
import org.apache.xmlgraphics.java2d.ps.AbstractPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractPSTranscoder
extends AbstractFOPTranscoder {
    protected AbstractPSDocumentGraphics2D graphics = null;
    private FontInfo fontInfo;

    protected abstract AbstractPSDocumentGraphics2D createDocumentGraphics2D();

    protected boolean getAutoFontsDefault() {
        return false;
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        this.graphics = this.createDocumentGraphics2D();
        if (!this.isTextStroked()) {
            try {
                boolean bl = false;
                this.fontInfo = PDFDocumentGraphics2DConfigurator.createFontInfo(this.getEffectiveConfiguration(), bl);
                this.graphics.setCustomTextHandler((TextHandler)new NativeTextHandler((PSGraphics2D)this.graphics, this.fontInfo));
            }
            catch (FOPException fOPException) {
                throw new TranscoderException((Exception)fOPException);
            }
        }
        super.transcode(document, string, transcoderOutput);
        this.getLogger().trace((Object)("document size: " + this.width + " x " + this.height));
        UnitProcessor.Context context = UnitProcessor.createContext((BridgeContext)this.ctx, (Element)document.getDocumentElement());
        float f = UnitProcessor.userSpaceToSVG((float)this.width, (short)9, (short)2, (UnitProcessor.Context)context);
        int n = (int)((double)f + 0.5);
        float f2 = UnitProcessor.userSpaceToSVG((float)this.height, (short)9, (short)2, (UnitProcessor.Context)context);
        int n2 = (int)((double)f2 + 0.5);
        this.getLogger().trace((Object)("document size: " + n + "pt x " + n2 + "pt"));
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            if (!(outputStream instanceof BufferedOutputStream)) {
                outputStream = new BufferedOutputStream(outputStream);
            }
            this.graphics.setupDocument(outputStream, n, n2);
            this.graphics.setViewportDimension(this.width, this.height);
            if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.setTransform(this.curTxf);
            this.root.paint((Graphics2D)this.graphics);
            this.graphics.finish();
        }
        catch (IOException iOException) {
            throw new TranscoderException((Exception)iOException);
        }
    }

    protected BridgeContext createBridgeContext() {
        return this.createBridgeContext("1.x");
    }

    public BridgeContext createBridgeContext(String string) {
        PSBridgeContext pSBridgeContext = new PSBridgeContext(this.userAgent, this.isTextStroked() ? null : this.fontInfo, this.getImageManager(), this.getImageSessionContext());
        return pSBridgeContext;
    }
}

