/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.ps.PSBorderPainter;
import org.apache.fop.render.ps.PSDocumentHandler;
import org.apache.fop.render.ps.PSFontResource;
import org.apache.fop.render.ps.PSImageUtils;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.fop.render.ps.PSRenderingMode;
import org.apache.fop.render.ps.PSRenderingUtil;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.HexEncoder;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.w3c.dom.Document;

public class PSPainter
extends AbstractIFPainter {
    private static Log log = LogFactory.getLog(PSPainter.class);
    private PSDocumentHandler documentHandler;
    private PSBorderPainter borderPainter;
    private boolean inTextMode = false;

    public PSPainter(PSDocumentHandler pSDocumentHandler) {
        this(pSDocumentHandler, IFState.create());
    }

    protected PSPainter(PSDocumentHandler pSDocumentHandler, IFState iFState) {
        this.documentHandler = pSDocumentHandler;
        this.borderPainter = new PSBorderPainter(pSDocumentHandler.gen);
        this.state = iFState;
    }

    protected IFContext getContext() {
        return this.documentHandler.getContext();
    }

    PSRenderingUtil getPSUtil() {
        return this.documentHandler.psUtil;
    }

    FontInfo getFontInfo() {
        return this.documentHandler.getFontInfo();
    }

    private PSGenerator getGenerator() {
        return this.documentHandler.gen;
    }

    public void startViewport(AffineTransform affineTransform, Dimension dimension, Rectangle rectangle) throws IFException {
        try {
            PSGenerator pSGenerator = this.getGenerator();
            this.saveGraphicsState();
            pSGenerator.concatMatrix(PSPainter.toPoints(affineTransform));
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startViewport()", iOException);
        }
        if (rectangle != null) {
            this.clipRect(rectangle);
        }
    }

    public void endViewport() throws IFException {
        try {
            this.restoreGraphicsState();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endViewport()", iOException);
        }
    }

    public void startGroup(AffineTransform affineTransform) throws IFException {
        try {
            PSGenerator pSGenerator = this.getGenerator();
            this.saveGraphicsState();
            pSGenerator.concatMatrix(PSPainter.toPoints(affineTransform));
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startGroup()", iOException);
        }
    }

    public void endGroup() throws IFException {
        try {
            this.restoreGraphicsState();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endGroup()", iOException);
        }
    }

    protected Map createDefaultImageProcessingHints(ImageSessionContext imageSessionContext) {
        Map map = super.createDefaultImageProcessingHints(imageSessionContext);
        map.put(ImageProcessingHints.TRANSPARENCY_INTENT, "ignore");
        return map;
    }

    protected RenderingContext createRenderingContext() {
        PSRenderingContext pSRenderingContext = new PSRenderingContext(this.getUserAgent(), this.getGenerator(), this.getFontInfo());
        return pSRenderingContext;
    }

    protected void drawImageUsingImageHandler(ImageInfo imageInfo, Rectangle rectangle) throws ImageException, IOException {
        if (!this.getPSUtil().isOptimizeResources() || PSImageUtils.isImageInlined(imageInfo, (PSRenderingContext)this.createRenderingContext())) {
            super.drawImageUsingImageHandler(imageInfo, rectangle);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Image " + imageInfo + " is embedded as a form later"));
            }
            PSResource pSResource = this.documentHandler.getFormForImage(imageInfo.getOriginalURI());
            PSImageUtils.drawForm(pSResource, imageInfo, rectangle, this.getGenerator());
        }
    }

    public void drawImage(String string, Rectangle rectangle) throws IFException {
        try {
            this.endTextObject();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in drawImage()", iOException);
        }
        this.drawImageUsingURI(string, rectangle);
    }

    public void drawImage(Document document, Rectangle rectangle) throws IFException {
        try {
            this.endTextObject();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in drawImage()", iOException);
        }
        this.drawImageUsingDocument(document, rectangle);
    }

    public void clipRect(Rectangle rectangle) throws IFException {
        try {
            PSGenerator pSGenerator = this.getGenerator();
            this.endTextObject();
            pSGenerator.defineRect((double)rectangle.x / 1000.0, (double)rectangle.y / 1000.0, (double)rectangle.width / 1000.0, (double)rectangle.height / 1000.0);
            pSGenerator.writeln(pSGenerator.mapCommand("clip") + " " + pSGenerator.mapCommand("newpath"));
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in clipRect()", iOException);
        }
    }

    public void fillRect(Rectangle rectangle, Paint paint) throws IFException {
        if (paint == null) {
            return;
        }
        if (rectangle.width != 0 && rectangle.height != 0) {
            try {
                this.endTextObject();
                PSGenerator pSGenerator = this.getGenerator();
                if (paint != null) {
                    if (paint instanceof Color) {
                        pSGenerator.useColor((Color)paint);
                    } else {
                        throw new UnsupportedOperationException("Non-Color paints NYI");
                    }
                }
                pSGenerator.defineRect((double)rectangle.x / 1000.0, (double)rectangle.y / 1000.0, (double)rectangle.width / 1000.0, (double)rectangle.height / 1000.0);
                pSGenerator.writeln(pSGenerator.mapCommand("fill"));
            }
            catch (IOException iOException) {
                throw new IFException("I/O error in fillRect()", iOException);
            }
        }
    }

    public void drawBorderRect(Rectangle rectangle, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) throws IFException {
        if (borderProps != null || borderProps2 != null || borderProps3 != null || borderProps4 != null) {
            try {
                this.endTextObject();
                if (this.getPSUtil().getRenderingMode() == PSRenderingMode.SIZE && this.hasOnlySolidBorders(borderProps, borderProps2, borderProps3, borderProps4)) {
                    super.drawBorderRect(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
                } else {
                    this.borderPainter.drawBorders(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
                }
            }
            catch (IOException iOException) {
                throw new IFException("I/O error in drawBorderRect()", iOException);
            }
        }
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) throws IFException {
        try {
            this.endTextObject();
            this.borderPainter.drawLine(point, point2, n, color, ruleStyle);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in drawLine()", iOException);
        }
    }

    private Typeface getTypeface(String string) {
        if (string == null) {
            throw new NullPointerException("fontName must not be null");
        }
        Typeface typeface = this.getFontInfo().getFonts().get(string);
        if (typeface instanceof LazyFont) {
            typeface = ((LazyFont)typeface).getRealFont();
        }
        return typeface;
    }

    protected void saveGraphicsState() throws IOException {
        this.endTextObject();
        this.getGenerator().saveGraphicsState();
    }

    protected void restoreGraphicsState() throws IOException {
        this.endTextObject();
        this.getGenerator().restoreGraphicsState();
    }

    protected void beginTextObject() throws IOException {
        if (!this.inTextMode) {
            PSGenerator pSGenerator = this.getGenerator();
            pSGenerator.saveGraphicsState();
            pSGenerator.writeln("BT");
            this.inTextMode = true;
        }
    }

    protected void endTextObject() throws IOException {
        if (this.inTextMode) {
            this.inTextMode = false;
            PSGenerator pSGenerator = this.getGenerator();
            pSGenerator.writeln("ET");
            pSGenerator.restoreGraphicsState();
        }
    }

    private String formatMptAsPt(PSGenerator pSGenerator, int n) {
        return pSGenerator.formatDouble((double)n / 1000.0);
    }

    public void drawText(int n, int n2, int n3, int n4, int[][] nArray, String string) throws IFException {
        try {
            if (this.state.getFontSize() == 0) {
                return;
            }
            PSGenerator pSGenerator = this.getGenerator();
            pSGenerator.useColor(this.state.getTextColor());
            this.beginTextObject();
            FontTriplet fontTriplet = new FontTriplet(this.state.getFontFamily(), this.state.getFontStyle(), this.state.getFontWeight());
            String string2 = this.getFontInfo().getInternalFontKey(fontTriplet);
            if (string2 == null) {
                throw new IFException("Font not available: " + fontTriplet, null);
            }
            int n5 = this.state.getFontSize();
            Typeface typeface = this.getTypeface(string2);
            SingleByteFont singleByteFont = null;
            if (typeface instanceof SingleByteFont) {
                singleByteFont = (SingleByteFont)typeface;
            }
            Font font = this.getFontInfo().getFontInstance(fontTriplet, n5);
            this.useFont(string2, n5);
            pSGenerator.writeln("1 0 0 -1 " + this.formatMptAsPt(pSGenerator, n) + " " + this.formatMptAsPt(pSGenerator, n2) + " Tm");
            int n6 = string.length();
            int n7 = 0;
            if (singleByteFont != null) {
                int n8 = -1;
                for (int i = 0; i < n6; ++i) {
                    char c = string.charAt(i);
                    char c2 = typeface.mapChar(c);
                    int n9 = c2 / 256;
                    if (n8 == n9) continue;
                    if (i > 0) {
                        this.writeText(string, n7, i - n7, n3, n4, nArray, font, typeface, false);
                    }
                    if (n9 == 0) {
                        this.useFont(string2, n5);
                    } else {
                        this.useFont(string2 + "_" + Integer.toString(n9), n5);
                    }
                    n8 = n9;
                    n7 = i;
                }
            } else {
                this.useFont(string2, n5);
            }
            this.writeText(string, n7, n6 - n7, n3, n4, nArray, font, typeface, typeface instanceof MultiByteFont);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in drawText()", iOException);
        }
    }

    private void writeText(String string, int n, int n2, int n3, int n4, int[][] nArray, Font font, Typeface typeface, boolean bl) throws IOException {
        PSGenerator pSGenerator = this.getGenerator();
        int n5 = n + n2;
        int n6 = n2;
        n6 += n6 / 2;
        boolean bl2 = n3 != 0;
        boolean bl3 = false;
        int n7 = 0;
        StringBuffer stringBuffer = new StringBuffer(n6);
        StringBuffer stringBuffer2 = new StringBuffer(n6);
        int[] nArray2 = IFUtil.convertDPToDX(nArray);
        int n8 = nArray2 != null ? nArray2.length : 0;
        for (int i = n; i < n5; ++i) {
            int n9;
            char c;
            char c2 = string.charAt(i);
            int n10 = 0;
            if (CharUtilities.isFixedWidthSpace(c2)) {
                c = font.mapChar(' ');
                n9 = font.getCharWidth(c2);
                n10 = font.getCharWidth(c) - n9;
            } else {
                if (n4 != 0 && CharUtilities.isAdjustableSpace(c2)) {
                    n10 -= n4;
                }
                c = font.mapChar(c2);
                n9 = font.getCharWidth(c2);
            }
            if (nArray2 != null && i < n8 - 1) {
                n10 -= nArray2[i + 1];
            }
            if (bl) {
                stringBuffer.append(HexEncoder.encode(c));
            } else {
                char c3 = (char)(c % 256);
                PSGenerator.escapeChar((char)c3, (StringBuffer)stringBuffer);
            }
            if (n10 == 0) continue;
            bl3 = true;
            if (stringBuffer2.length() == 0) {
                stringBuffer2.append('[');
            }
            if (stringBuffer.length() > 0) {
                if (stringBuffer2.length() - n7 + stringBuffer.length() > 200) {
                    stringBuffer2.append('\n');
                    n7 = stringBuffer2.length();
                }
                n7 = this.writePostScriptString(stringBuffer2, stringBuffer, bl, n7);
                stringBuffer2.append(' ');
                stringBuffer.setLength(0);
            }
            stringBuffer2.append(Integer.toString(n10)).append(' ');
        }
        if (bl3) {
            if (stringBuffer.length() > 0) {
                if (stringBuffer2.length() - n7 + stringBuffer.length() > 200) {
                    stringBuffer2.append('\n');
                }
                this.writePostScriptString(stringBuffer2, stringBuffer, bl);
            }
            if (bl2) {
                stringBuffer2.append("] " + this.formatMptAsPt(pSGenerator, n3) + " ATJ");
            } else {
                stringBuffer2.append("] TJ");
            }
        } else {
            this.writePostScriptString(stringBuffer2, stringBuffer, bl);
            if (bl2) {
                StringBuffer stringBuffer3 = new StringBuffer();
                stringBuffer3.append(this.formatMptAsPt(pSGenerator, n3)).append(" 0 ");
                stringBuffer2.insert(0, stringBuffer3.toString());
                stringBuffer2.append(" " + pSGenerator.mapCommand("ashow"));
            } else {
                stringBuffer2.append(" " + pSGenerator.mapCommand("show"));
            }
        }
        pSGenerator.writeln(stringBuffer2.toString());
    }

    private void writePostScriptString(StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl) {
        this.writePostScriptString(stringBuffer, stringBuffer2, bl, 0);
    }

    private int writePostScriptString(StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl, int n) {
        stringBuffer.append(bl ? (char)'<' : '(');
        int n2 = stringBuffer2.length();
        int n3 = 0;
        int n4 = 200;
        stringBuffer.append(stringBuffer2.substring(n3, Math.min(n3 + n4, n2)));
        n3 += n4;
        while (n3 < n2) {
            if (!bl) {
                stringBuffer.append('\\');
            }
            stringBuffer.append('\n');
            n = stringBuffer.length();
            stringBuffer.append(stringBuffer2.substring(n3, Math.min(n3 + n4, n2)));
            n3 += n4;
        }
        stringBuffer.append(bl ? (char)'>' : ')');
        return n;
    }

    private void useFont(String string, int n) throws IOException {
        PSFontResource pSFontResource = this.documentHandler.getPSResourceForFontKey(string);
        PSGenerator pSGenerator = this.getGenerator();
        pSGenerator.useFont("/" + pSFontResource.getName(), (float)n / 1000.0f);
        pSFontResource.notifyResourceUsageOnPage(pSGenerator.getResourceTracker());
    }
}

