/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import java.awt.Color;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.render.rtf.BorderAttributesConverter;
import org.apache.fop.render.rtf.FOPRtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;

public final class TableAttributesConverter {
    private TableAttributesConverter() {
    }

    static RtfAttributes convertTableAttributes(Table table) throws FOPException {
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        fOPRtfAttributes.setTwips("trleft", table.getCommonMarginBlock().marginLeft);
        return fOPRtfAttributes;
    }

    static RtfAttributes convertTablePartAttributes(TablePart tablePart) throws FOPException {
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        return fOPRtfAttributes;
    }

    static RtfAttributes convertCellAttributes(TableCell tableCell) throws FOPException {
        int n;
        int n2;
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        CommonBorderPaddingBackground commonBorderPaddingBackground = tableCell.getCommonBorderPaddingBackground();
        Color color = commonBorderPaddingBackground.backgroundColor;
        if (color == null) {
            TableFObj tableFObj;
            CommonBorderPaddingBackground commonBorderPaddingBackground2 = null;
            if (tableCell.getParent() instanceof TableRow) {
                tableFObj = (TableRow)tableCell.getParent();
                commonBorderPaddingBackground2 = ((TableRow)tableFObj).getCommonBorderPaddingBackground();
                color = commonBorderPaddingBackground2.backgroundColor;
            } else if (tableCell.getParent() instanceof TableHeader) {
                tableFObj = (TableHeader)tableCell.getParent();
                commonBorderPaddingBackground2 = ((TablePart)tableFObj).getCommonBorderPaddingBackground();
                color = commonBorderPaddingBackground2.backgroundColor;
            }
            if (color == null && tableCell.getParent() != null && tableCell.getParent().getParent() != null && tableCell.getParent().getParent().getParent() instanceof Table) {
                tableFObj = (Table)tableCell.getParent().getParent().getParent();
                commonBorderPaddingBackground2 = ((Table)tableFObj).getCommonBorderPaddingBackground();
                color = commonBorderPaddingBackground2.backgroundColor;
            }
        }
        if (color != null && (color.getAlpha() != 0 || color.getRed() != 0 || color.getGreen() != 0 || color.getBlue() != 0)) {
            fOPRtfAttributes.set("clcbpat", color);
        }
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 0, fOPRtfAttributes, "clbrdrt");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 1, fOPRtfAttributes, "clbrdrb");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 2, fOPRtfAttributes, "clbrdrl");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 3, fOPRtfAttributes, "clbrdrr");
        boolean bl = true;
        if (bl) {
            n2 = commonBorderPaddingBackground.getPaddingStart(false, null);
            if (n2 != 0) {
                fOPRtfAttributes.setTwips("clpadt", n2);
                fOPRtfAttributes.set("clpadft", 3);
            }
            if ((n2 = commonBorderPaddingBackground.getPaddingBefore(false, null)) != 0) {
                fOPRtfAttributes.setTwips("clpadl", n2);
                fOPRtfAttributes.set("clpadfl", 3);
            }
        } else {
            n2 = commonBorderPaddingBackground.getPaddingStart(false, null);
            if (n2 != 0) {
                fOPRtfAttributes.setTwips("clpadl", n2);
                fOPRtfAttributes.set("clpadfl", 3);
            }
            if ((n2 = commonBorderPaddingBackground.getPaddingBefore(false, null)) != 0) {
                fOPRtfAttributes.setTwips("clpadt", n2);
                fOPRtfAttributes.set("clpadft", 3);
            }
        }
        if ((n2 = commonBorderPaddingBackground.getPaddingEnd(false, null)) != 0) {
            fOPRtfAttributes.setTwips("clpadr", n2);
            fOPRtfAttributes.set("clpadfr", 3);
        }
        if ((n2 = commonBorderPaddingBackground.getPaddingAfter(false, null)) != 0) {
            fOPRtfAttributes.setTwips("clpadb", n2);
            fOPRtfAttributes.set("clpadfb", 3);
        }
        if ((n = tableCell.getNumberColumnsSpanned()) > 1) {
            fOPRtfAttributes.set("number-columns-spanned", n);
        }
        switch (tableCell.getDisplayAlign()) {
            case 13: {
                fOPRtfAttributes.set("clvertalt");
                break;
            }
            case 23: {
                fOPRtfAttributes.set("clvertalc");
                break;
            }
            case 3: {
                fOPRtfAttributes.set("clvertalb");
                break;
            }
        }
        return fOPRtfAttributes;
    }

    static RtfAttributes convertRowAttributes(TableRow tableRow, RtfAttributes rtfAttributes) throws FOPException {
        RtfAttributes rtfAttributes2 = null;
        rtfAttributes2 = rtfAttributes == null ? new RtfAttributes() : rtfAttributes;
        if (tableRow.getKeepTogether().getWithinPage().getEnum() == 7) {
            rtfAttributes2.set("trkeep");
        }
        if (tableRow.getKeepWithNext().getWithinPage().getEnum() == 7) {
            rtfAttributes2.set("knext");
        }
        if (tableRow.getKeepWithPrevious().getWithinPage().getEnum() == 7) {
            rtfAttributes2.set("kprevious");
        }
        if (tableRow.getHeight().getEnum() != 9) {
            rtfAttributes2.set("trrh", tableRow.getHeight().getValue() / 50);
        }
        CommonBorderPaddingBackground commonBorderPaddingBackground = tableRow.getCommonBorderPaddingBackground();
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 0, rtfAttributes2, "clbrdrt");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 1, rtfAttributes2, "clbrdrb");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 2, rtfAttributes2, "clbrdrl");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 3, rtfAttributes2, "clbrdrr");
        return rtfAttributes2;
    }
}

