/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.traits.MinOptMax;

public class SpaceVal {
    private final MinOptMax space;
    private final boolean conditional;
    private final boolean forcing;
    private final int precedence;

    public SpaceVal(SpaceProperty spaceProperty, PercentBaseContext percentBaseContext) {
        this.space = SpaceVal.createSpaceProperty(spaceProperty, percentBaseContext);
        this.conditional = spaceProperty.getConditionality().getEnum() == 32;
        Property property = spaceProperty.getPrecedence();
        if (property.getNumber() != null) {
            this.precedence = property.getNumber().intValue();
            this.forcing = false;
        } else {
            this.forcing = property.getEnum() == 53;
            this.precedence = 0;
        }
    }

    private static MinOptMax createSpaceProperty(SpaceProperty spaceProperty, PercentBaseContext percentBaseContext) {
        int n = spaceProperty.getMinimum(percentBaseContext).getLength().getValue(percentBaseContext);
        int n2 = spaceProperty.getOptimum(percentBaseContext).getLength().getValue(percentBaseContext);
        int n3 = spaceProperty.getMaximum(percentBaseContext).getLength().getValue(percentBaseContext);
        return MinOptMax.getInstance(n, n2, n3);
    }

    public SpaceVal(MinOptMax minOptMax, boolean bl, boolean bl2, int n) {
        this.space = minOptMax;
        this.conditional = bl;
        this.forcing = bl2;
        this.precedence = n;
    }

    public static SpaceVal makeWordSpacing(Property property, SpaceVal spaceVal, Font font) {
        if (property.getEnum() == 97) {
            int n = font.getCharWidth(' ');
            MinOptMax minOptMax = MinOptMax.getInstance(-n / 3, 0, n / 2);
            return new SpaceVal(minOptMax.plus(spaceVal.getSpace().mult(2)), true, true, 0);
        }
        return new SpaceVal(property.getSpace(), null);
    }

    public static SpaceVal makeLetterSpacing(Property property) {
        if (property.getEnum() == 97) {
            return new SpaceVal(MinOptMax.ZERO, true, true, 0);
        }
        return new SpaceVal(property.getSpace(), null);
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isForcing() {
        return this.forcing;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public MinOptMax getSpace() {
        return this.space;
    }

    public String toString() {
        return "SpaceVal: " + this.getSpace().toString();
    }
}

