/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.io.ObjectStreamException;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.TraitEnum;
import org.apache.fop.traits.WritingModeTraitsSetter;

public final class WritingMode
extends TraitEnum {
    private static final long serialVersionUID = 1L;
    private static final String[] WRITING_MODE_NAMES = new String[]{"lr-tb", "rl-tb", "tb-lr", "tb-rl"};
    private static final int[] WRITING_MODE_VALUES = new int[]{79, 121, 205, 140};
    public static final WritingMode LR_TB = new WritingMode(0);
    public static final WritingMode RL_TB = new WritingMode(1);
    public static final WritingMode TB_LR = new WritingMode(2);
    public static final WritingMode TB_RL = new WritingMode(3);
    private static final WritingMode[] WRITING_MODES = new WritingMode[]{LR_TB, RL_TB, TB_LR, TB_RL};

    private WritingMode(int n) {
        super(WRITING_MODE_NAMES[n], WRITING_MODE_VALUES[n]);
    }

    public void assignWritingModeTraits(WritingModeTraitsSetter writingModeTraitsSetter) {
        Direction direction;
        Direction direction2;
        Direction direction3;
        Direction direction4;
        Direction direction5;
        switch (this.getEnumValue()) {
            case 121: {
                direction5 = Direction.RL;
                direction4 = Direction.TB;
                direction3 = Direction.RL;
                direction2 = Direction.TB;
                direction = Direction.BT;
                break;
            }
            case 205: {
                direction5 = Direction.TB;
                direction4 = Direction.LR;
                direction3 = Direction.TB;
                direction2 = Direction.LR;
                direction = Direction.RL;
                break;
            }
            case 140: {
                direction5 = Direction.TB;
                direction4 = Direction.RL;
                direction3 = Direction.TB;
                direction2 = Direction.RL;
                direction = Direction.LR;
                break;
            }
            default: {
                direction5 = Direction.LR;
                direction4 = Direction.TB;
                direction3 = Direction.LR;
                direction2 = Direction.TB;
                direction = Direction.BT;
            }
        }
        writingModeTraitsSetter.setInlineProgressionDirection(direction5);
        writingModeTraitsSetter.setBlockProgressionDirection(direction4);
        writingModeTraitsSetter.setColumnProgressionDirection(direction3);
        writingModeTraitsSetter.setRowProgressionDirection(direction2);
        writingModeTraitsSetter.setShiftDirection(direction);
        writingModeTraitsSetter.setWritingMode(this);
    }

    public boolean isHorizontal() {
        switch (this.getEnumValue()) {
            case 79: 
            case 121: {
                return true;
            }
            case 140: 
            case 205: {
                return false;
            }
        }
        assert (false);
        return true;
    }

    public boolean isVertical() {
        return !this.isHorizontal();
    }

    public static WritingMode valueOf(String string) {
        for (int i = 0; i < WRITING_MODES.length; ++i) {
            if (!WRITING_MODES[i].getName().equalsIgnoreCase(string)) continue;
            return WRITING_MODES[i];
        }
        throw new IllegalArgumentException("Illegal writing mode: " + string);
    }

    public static WritingMode valueOf(int n) {
        for (int i = 0; i < WRITING_MODES.length; ++i) {
            if (WRITING_MODES[i].getEnumValue() != n) continue;
            return WRITING_MODES[i];
        }
        throw new IllegalArgumentException("Illegal writing mode: " + n);
    }

    private Object readResolve() throws ObjectStreamException {
        return WritingMode.valueOf(this.getName());
    }

    public String toString() {
        return this.getName();
    }
}

