/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public abstract class AbstractPaintingState
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5998356138437094188L;
    private AbstractData data = null;
    private StateStack stateStack = new StateStack();

    protected abstract AbstractData instantiateData();

    protected abstract AbstractPaintingState instantiate();

    public AbstractData getData() {
        if (this.data == null) {
            this.data = this.instantiateData();
        }
        return this.data;
    }

    public boolean setColor(Color color) {
        Color color2 = this.getData().color;
        if (!ColorUtil.isSameColor((Color)color, (Color)color2)) {
            this.getData().color = color;
            return true;
        }
        return false;
    }

    public Color getColor() {
        if (this.getData().color == null) {
            this.getData().color = Color.black;
        }
        return this.getData().color;
    }

    public Color getBackColor() {
        if (this.getData().backColor == null) {
            this.getData().backColor = Color.white;
        }
        return this.getData().backColor;
    }

    public boolean setBackColor(Color color) {
        Color color2 = this.getData().backColor;
        if (!ColorUtil.isSameColor((Color)color, (Color)color2)) {
            this.getData().backColor = color;
            return true;
        }
        return false;
    }

    public boolean setFontName(String string) {
        if (!string.equals(this.getData().fontName)) {
            this.getData().fontName = string;
            return true;
        }
        return false;
    }

    public String getFontName() {
        return this.getData().fontName;
    }

    public int getFontSize() {
        return this.getData().fontSize;
    }

    public boolean setFontSize(int n) {
        if (n != this.getData().fontSize) {
            this.getData().fontSize = n;
            return true;
        }
        return false;
    }

    public boolean setLineWidth(float f) {
        if (this.getData().lineWidth != f) {
            this.getData().lineWidth = f;
            return true;
        }
        return false;
    }

    public float getLineWidth() {
        return this.getData().lineWidth;
    }

    public boolean setDashArray(float[] fArray) {
        if (!Arrays.equals(fArray, this.getData().dashArray)) {
            this.getData().dashArray = fArray;
            return true;
        }
        return false;
    }

    public AffineTransform getTransform() {
        AffineTransform affineTransform = new AffineTransform();
        for (AbstractData abstractData : this.stateStack) {
            AffineTransform affineTransform2 = abstractData.getTransform();
            affineTransform.concatenate(affineTransform2);
        }
        AffineTransform affineTransform3 = this.getData().getTransform();
        affineTransform.concatenate(affineTransform3);
        return affineTransform;
    }

    public boolean checkTransform(AffineTransform affineTransform) {
        return !affineTransform.equals(this.getData().getTransform());
    }

    public AffineTransform getBaseTransform() {
        if (this.stateStack.isEmpty()) {
            return null;
        }
        AbstractData abstractData = (AbstractData)this.stateStack.get(0);
        return (AffineTransform)abstractData.getTransform().clone();
    }

    public void concatenate(AffineTransform affineTransform) {
        this.getData().concatenate(affineTransform);
    }

    public void resetTransform() {
        this.getData().setTransform(this.getBaseTransform());
    }

    public void clearTransform() {
        this.getData().clearTransform();
    }

    public void save() {
        AbstractData abstractData = (AbstractData)this.getData().clone();
        this.stateStack.push(abstractData);
    }

    public AbstractData restore() {
        if (!this.stateStack.isEmpty()) {
            this.setData((AbstractData)this.stateStack.pop());
            return this.data;
        }
        return null;
    }

    public void saveAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.save();
            this.setData((AbstractData)iterator.next());
        }
    }

    public List restoreAll() {
        ArrayList<AbstractData> arrayList = new ArrayList<AbstractData>();
        while (true) {
            AbstractData abstractData = this.getData();
            if (this.restore() == null) break;
            arrayList.add(0, abstractData);
        }
        return arrayList;
    }

    protected void setData(AbstractData abstractData) {
        this.data = abstractData;
    }

    public void clear() {
        this.stateStack.clear();
        this.setData(null);
    }

    protected Stack getStateStack() {
        return this.stateStack;
    }

    public Object clone() {
        AbstractPaintingState abstractPaintingState = this.instantiate();
        abstractPaintingState.stateStack = new StateStack(this.stateStack);
        abstractPaintingState.data = (AbstractData)this.data.clone();
        return abstractPaintingState;
    }

    public String toString() {
        return ", stateStack=" + this.stateStack + ", currentData=" + this.data;
    }

    public abstract class AbstractData
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 5208418041189828624L;
        protected Color color = null;
        protected Color backColor = null;
        protected String fontName = null;
        protected int fontSize = 0;
        protected float lineWidth = 0.0f;
        protected float[] dashArray = null;
        protected AffineTransform transform = null;

        protected abstract AbstractData instantiate();

        public void concatenate(AffineTransform affineTransform) {
            this.getTransform().concatenate(affineTransform);
        }

        public AffineTransform getTransform() {
            if (this.transform == null) {
                this.transform = new AffineTransform();
            }
            return this.transform;
        }

        public void setTransform(AffineTransform affineTransform) {
            this.transform = affineTransform;
        }

        public void clearTransform() {
            this.transform = new AffineTransform();
        }

        public int getDerivedRotation() {
            AffineTransform affineTransform = this.getTransform();
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getScaleY();
            double d3 = affineTransform.getShearX();
            double d4 = affineTransform.getShearY();
            int n = 0;
            n = d == 0.0 && d2 == 0.0 && d3 > 0.0 && d4 < 0.0 ? 270 : (d < 0.0 && d2 < 0.0 && d3 == 0.0 && d4 == 0.0 ? 180 : (d == 0.0 && d2 == 0.0 && d3 < 0.0 && d4 > 0.0 ? 90 : 0));
            return n;
        }

        public Object clone() {
            AbstractData abstractData = this.instantiate();
            abstractData.color = this.color;
            abstractData.backColor = this.backColor;
            abstractData.fontName = this.fontName;
            abstractData.fontSize = this.fontSize;
            abstractData.lineWidth = this.lineWidth;
            abstractData.dashArray = this.dashArray;
            if (this.transform == null) {
                this.transform = new AffineTransform();
            }
            abstractData.transform = new AffineTransform(this.transform);
            return abstractData;
        }

        public String toString() {
            return "color=" + this.color + ", backColor=" + this.backColor + ", fontName=" + this.fontName + ", fontSize=" + this.fontSize + ", lineWidth=" + this.lineWidth + ", dashArray=" + this.dashArray + ", transform=" + this.transform;
        }
    }

    public class StateStack
    extends Stack {
        private static final long serialVersionUID = 4897178211223823041L;

        public StateStack() {
        }

        public StateStack(Collection collection) {
            this.elementCount = collection.size();
            this.elementData = new Object[(int)Math.min((long)this.elementCount * 110L / 100L, Integer.MAX_VALUE)];
            collection.toArray(this.elementData);
        }
    }
}

