/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.xmlgraphics.util.Service;

public class ContentHandlerFactoryRegistry {
    private static Log log = LogFactory.getLog(ContentHandlerFactoryRegistry.class);
    private Map factories = new HashMap();

    public ContentHandlerFactoryRegistry() {
        this.discover();
    }

    public void addContentHandlerFactory(String string) {
        try {
            ContentHandlerFactory contentHandlerFactory = (ContentHandlerFactory)Class.forName(string).newInstance();
            this.addContentHandlerFactory(contentHandlerFactory);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + " is not an " + ContentHandlerFactory.class.getName());
        }
    }

    public void addContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        String[] stringArray = contentHandlerFactory.getSupportedNamespaces();
        for (int i = 0; i < stringArray.length; ++i) {
            this.factories.put(stringArray[i], contentHandlerFactory);
        }
    }

    public ContentHandlerFactory getFactory(String string) {
        ContentHandlerFactory contentHandlerFactory = (ContentHandlerFactory)this.factories.get(string);
        return contentHandlerFactory;
    }

    private void discover() {
        Iterator iterator = Service.providers(ContentHandlerFactory.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                ContentHandlerFactory contentHandlerFactory = (ContentHandlerFactory)iterator.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding ContentHandlerFactory: " + contentHandlerFactory.getClass().getName()));
                    }
                    this.addContentHandlerFactory(contentHandlerFactory);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)"Error while adding ContentHandlerFactory", (Throwable)illegalArgumentException);
                }
            }
        }
    }
}

