/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLResourceBundle
extends ResourceBundle {
    private Properties resources = new Properties();
    private Locale locale;
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private static final ResourceBundle MISSING = new MissingBundle();
    private static final ResourceBundle MISSINGBASE = new MissingBundle();
    private static Map cache = new WeakHashMap();

    public XMLResourceBundle(InputStream inputStream) throws IOException {
        try {
            Transformer transformer = tFactory.newTransformer();
            StreamSource streamSource = new StreamSource(inputStream);
            SAXResult sAXResult = new SAXResult(new CatalogueHandler());
            transformer.transform(streamSource, sAXResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Error while parsing XML resource bundle: " + transformerException.getMessage());
        }
    }

    public static ResourceBundle getXMLBundle(String string, ClassLoader classLoader) throws MissingResourceException {
        return XMLResourceBundle.getXMLBundle(string, Locale.getDefault(), classLoader);
    }

    public static ResourceBundle getXMLBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        ResourceBundle resourceBundle;
        if (classLoader == null) {
            throw new NullPointerException("loader must not be null");
        }
        if (string == null) {
            throw new NullPointerException("baseName must not be null");
        }
        assert (locale != null);
        if (!locale.equals(Locale.getDefault()) && (resourceBundle = XMLResourceBundle.handleGetXMLBundle(string, "_" + locale, false, classLoader)) != null) {
            return resourceBundle;
        }
        resourceBundle = XMLResourceBundle.handleGetXMLBundle(string, "_" + Locale.getDefault(), true, classLoader);
        if (resourceBundle != null) {
            return resourceBundle;
        }
        throw new MissingResourceException(string + " (" + locale + ")", string + '_' + locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle handleGetXMLBundle(String string, String string2, boolean bl, final ClassLoader classLoader) {
        ResourceBundle resourceBundle;
        Hashtable<String, ResourceBundle> hashtable;
        XMLResourceBundle xMLResourceBundle = null;
        String string3 = string + string2;
        Object object = classLoader != null ? classLoader : "null";
        Object object2 = cache;
        synchronized (object2) {
            hashtable = (Hashtable<String, ResourceBundle>)cache.get(object);
            if (hashtable == null) {
                hashtable = new Hashtable<String, ResourceBundle>();
                cache.put(object, hashtable);
            }
        }
        object2 = (ResourceBundle)hashtable.get(string3);
        if (object2 != null) {
            if (object2 == MISSINGBASE) {
                return null;
            }
            if (object2 == MISSING) {
                if (!bl) {
                    return null;
                }
                String string4 = XMLResourceBundle.strip(string2);
                if (string4 == null) {
                    return null;
                }
                return XMLResourceBundle.handleGetXMLBundle(string, string4, bl, classLoader);
            }
            return object2;
        }
        final String string5 = string3.replace('.', '/') + ".xml";
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classLoader == null ? ClassLoader.getSystemResourceAsStream(string5) : classLoader.getResourceAsStream(string5);
            }
        });
        if (inputStream != null) {
            try {
                try {
                    xMLResourceBundle = new XMLResourceBundle(inputStream);
                }
                finally {
                    inputStream.close();
                }
                xMLResourceBundle.setLocale(string2);
            }
            catch (IOException iOException) {
                throw new MissingResourceException(iOException.getMessage(), string, null);
            }
        }
        String string6 = XMLResourceBundle.strip(string2);
        if (xMLResourceBundle != null) {
            ResourceBundle resourceBundle2;
            if (string6 != null && (resourceBundle2 = XMLResourceBundle.handleGetXMLBundle(string, string6, true, classLoader)) != null) {
                xMLResourceBundle.setParent(resourceBundle2);
            }
            hashtable.put(string3, xMLResourceBundle);
            return xMLResourceBundle;
        }
        if (string6 != null && (resourceBundle = XMLResourceBundle.handleGetXMLBundle(string, string6, bl, classLoader)) != null) {
            hashtable.put(string3, resourceBundle);
            return resourceBundle;
        }
        hashtable.put(string3, bl ? MISSINGBASE : MISSING);
        return null;
    }

    private void setLocale(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (string.length() > 1) {
            int n = string.indexOf(95, 1);
            if (n == -1) {
                n = string.length();
            }
            string2 = string.substring(1, n);
            if (n + 1 < string.length()) {
                int n2 = n;
                if ((n = string.indexOf(95, n + 1)) == -1) {
                    n = string.length();
                }
                string3 = string.substring(n2 + 1, n);
                if (n + 1 < string.length()) {
                    string4 = string.substring(n + 1, string.length());
                }
            }
        }
        this.locale = new Locale(string2, string3, string4);
    }

    private static String strip(String string) {
        int n = string.lastIndexOf(95);
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    private Enumeration getLocalKeys() {
        return this.resources.propertyNames();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getKeys() {
        if (this.parent == null) {
            return this.getLocalKeys();
        }
        return new Enumeration(){
            private Enumeration local;
            private Enumeration pEnum;
            private Object nextElement;
            {
                this.local = XMLResourceBundle.this.getLocalKeys();
                this.pEnum = XMLResourceBundle.this.parent.getKeys();
            }

            private boolean findNext() {
                if (this.nextElement != null) {
                    return true;
                }
                while (this.pEnum.hasMoreElements()) {
                    Object e = this.pEnum.nextElement();
                    if (XMLResourceBundle.this.resources.containsKey(e)) continue;
                    this.nextElement = e;
                    return true;
                }
                return false;
            }

            public boolean hasMoreElements() {
                if (this.local.hasMoreElements()) {
                    return true;
                }
                return this.findNext();
            }

            public Object nextElement() {
                if (this.local.hasMoreElements()) {
                    return this.local.nextElement();
                }
                if (this.findNext()) {
                    Object object = this.nextElement;
                    this.nextElement = null;
                    return object;
                }
                return this.pEnum.nextElement();
            }
        };
    }

    protected Object handleGetObject(String string) {
        if (string == null) {
            throw new NullPointerException("key must not be null");
        }
        return this.resources.get(string);
    }

    public String toString() {
        return "XMLResourceBundle: " + this.getLocale();
    }

    private class CatalogueHandler
    extends DefaultHandler {
        private static final String CATALOGUE = "catalogue";
        private static final String MESSAGE = "message";
        private StringBuffer valueBuffer = new StringBuffer();
        private Stack elementStack = new Stack();
        private String currentKey = null;

        private CatalogueHandler() {
        }

        private boolean isOwnNamespace(String string) {
            return "".equals(string);
        }

        private QName getParentElementName() {
            return (QName)this.elementStack.peek();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            QName qName = new QName(string, string3);
            if (this.isOwnNamespace(string) && !CATALOGUE.equals(string2)) {
                if (MESSAGE.equals(string2)) {
                    if (!CATALOGUE.equals(this.getParentElementName().getLocalName())) {
                        throw new SAXException("message must be a child of catalogue");
                    }
                    this.currentKey = attributes.getValue("key");
                } else {
                    throw new SAXException("Invalid element name: " + qName);
                }
            }
            this.valueBuffer.setLength(0);
            this.elementStack.push(qName);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            this.elementStack.pop();
            if (this.isOwnNamespace(string) && !CATALOGUE.equals(string2) && MESSAGE.equals(string2)) {
                if (this.currentKey == null) {
                    throw new SAXException("current key is null (attribute 'key' might be mistyped)");
                }
                XMLResourceBundle.this.resources.put(this.currentKey, this.valueBuffer.toString());
                this.currentKey = null;
            }
            this.valueBuffer.setLength(0);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            super.characters(cArray, n, n2);
            this.valueBuffer.append(cArray, n, n2);
        }
    }

    static class MissingBundle
    extends ResourceBundle {
        MissingBundle() {
        }

        public Enumeration getKeys() {
            return null;
        }

        public Object handleGetObject(String string) {
            return null;
        }
    }
}

