/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.bitmap;

import java.awt.Color;
import org.apache.fop.util.bitmap.BitmapImageUtil;

public final class DitherUtil {
    public static final int DITHER_MATRIX_2X2 = 2;
    public static final int DITHER_MATRIX_4X4 = 4;
    public static final int DITHER_MATRIX_8X8 = 8;
    private static final int[] BAYER_D2 = new int[]{0, 2, 3, 1};
    private static final int[] BAYER_D4 = DitherUtil.deriveBayerMatrix(BAYER_D2);
    private static final int[] BAYER_D8 = DitherUtil.deriveBayerMatrix(BAYER_D4);

    private DitherUtil() {
    }

    private static int[] deriveBayerMatrix(int[] nArray) {
        int[] nArray2 = new int[nArray.length * 4];
        int n = (int)Math.sqrt(nArray.length);
        for (int i = 0; i < 4; ++i) {
            int n2 = nArray.length;
            for (int j = 0; j < n2; ++j) {
                DitherUtil.setValueInMatrix(nArray2, n, i, j, nArray[j] * 4 + BAYER_D2[i]);
            }
        }
        return nArray2;
    }

    private static void setValueInMatrix(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = (n2 & 1) * n;
        int n6 = (n2 & 2) * n * n;
        int n7 = n6 + n3 / n * n * 2 + n3 % n + n5;
        nArray[n7] = n4;
    }

    public static int[] getBayerBasePattern(int n) {
        int[] nArray = new int[n * n];
        switch (n) {
            case 2: {
                System.arraycopy(BAYER_D2, 0, nArray, 0, BAYER_D2.length);
                break;
            }
            case 4: {
                System.arraycopy(BAYER_D4, 0, nArray, 0, BAYER_D4.length);
                break;
            }
            case 8: {
                System.arraycopy(BAYER_D8, 0, nArray, 0, BAYER_D8.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported dither matrix: " + n);
            }
        }
        return nArray;
    }

    public static byte[] getBayerDither(int n, int n2, boolean bl) {
        byte[] byArray;
        int[] nArray;
        int n3;
        switch (n) {
            case 4: {
                n3 = n2 * 17 / 255;
                nArray = BAYER_D4;
                break;
            }
            case 8: {
                n3 = n2 * 65 / 255;
                nArray = BAYER_D8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported dither matrix: " + n);
            }
        }
        if (bl) {
            if (bl && n != 4) {
                throw new IllegalArgumentException("doubleMatrix=true is only allowed for 4x4");
            }
            byArray = new byte[nArray.length / 8 * 4];
            int n4 = nArray.length;
            for (int i = 0; i < n4; ++i) {
                int n5;
                boolean bl2;
                boolean bl3 = bl2 = nArray[i] >= n3 - 1;
                if (!bl2) continue;
                int n6 = n5 = i / 4;
                byArray[n6] = (byte)(byArray[n6] | 1 << i % 4);
                int n7 = n5;
                byArray[n7] = (byte)(byArray[n7] | 1 << i % 4 + 4);
                int n8 = n5 + 4;
                byArray[n8] = (byte)(byArray[n8] | 1 << i % 4);
                int n9 = n5 + 4;
                byArray[n9] = (byte)(byArray[n9] | 1 << i % 4 + 4);
            }
        } else {
            byArray = new byte[nArray.length / 8];
            int n10 = nArray.length;
            for (int i = 0; i < n10; ++i) {
                int n11;
                boolean bl4;
                boolean bl5 = bl4 = nArray[i] >= n3 - 1;
                if (!bl4) continue;
                int n12 = n11 = i / 8;
                byArray[n12] = (byte)(byArray[n12] | 1 << i % 8);
            }
        }
        return byArray;
    }

    public static byte[] getBayerDither(int n, Color color, boolean bl) {
        float f = (float)BitmapImageUtil.convertToGray(color.getRGB()) / 256.0f;
        return DitherUtil.getBayerDither(n, Math.round(f * 256.0f), bl);
    }
}

