/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;

public class CompositeImageLoader
extends AbstractImageLoader {
    protected static Log log = LogFactory.getLog(CompositeImageLoader.class);
    private ImageLoader[] loaders;

    public CompositeImageLoader(ImageLoader[] imageLoaderArray) {
        if (imageLoaderArray == null || imageLoaderArray.length == 0) {
            throw new IllegalArgumentException("Must at least pass one ImageLoader as parameter");
        }
        int n = imageLoaderArray.length;
        for (int i = 1; i < n; ++i) {
            if (imageLoaderArray[0].getTargetFlavor().equals(imageLoaderArray[i].getTargetFlavor())) continue;
            throw new IllegalArgumentException("All ImageLoaders must produce the same target flavor");
        }
        this.loaders = imageLoaderArray;
    }

    public ImageFlavor getTargetFlavor() {
        return this.loaders[0].getTargetFlavor();
    }

    public int getUsagePenalty() {
        int n = 0;
        int n2 = this.loaders.length;
        for (int i = 1; i < n2; ++i) {
            n = Math.max(n, this.loaders[i].getUsagePenalty());
        }
        return n;
    }

    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        ImageException imageException = null;
        for (ImageLoader imageLoader : this.loaders) {
            try {
                Image image = imageLoader.loadImage(imageInfo, map, imageSessionContext);
                if (image != null && imageException != null) {
                    log.debug((Object)("First ImageLoader failed (" + imageException.getMessage() + "). Fallback was successful."));
                }
                return image;
            }
            catch (ImageException imageException2) {
                if (imageException != null) continue;
                imageException = imageException2;
            }
        }
        throw imageException;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.loaders.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.loaders[i].toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

