/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;

public class JPEGFile
implements JPEGConstants {
    protected static Log log = LogFactory.getLog(JPEGFile.class);
    private DataInput in;

    public JPEGFile(ImageInputStream imageInputStream) {
        this.in = imageInputStream;
    }

    public JPEGFile(InputStream inputStream) {
        this.in = new DataInputStream(inputStream);
    }

    public DataInput getDataInput() {
        return this.in;
    }

    public int readMarkerSegment() throws IOException {
        int n;
        int n2 = 0;
        do {
            n = this.in.readByte() & 0xFF;
            ++n2;
        } while (n != 255);
        if (n2 > 1) {
            throw new IOException("Stream not positioned at a marker segment header");
        }
        int n3 = this.in.readByte() & 0xFF;
        return n3;
    }

    public int readSegmentLength() throws IOException {
        int n = this.in.readUnsignedShort();
        return n;
    }

    public void skipCurrentMarkerSegment() throws IOException {
        int n = this.readSegmentLength();
        this.in.skipBytes(n - 2);
    }
}

