/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl.imageio;

import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.IIOServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.imageio.ImageIOUtil;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;
import org.w3c.dom.Element;

public class ImageLoaderImageIO
extends AbstractImageLoader {
    protected static Log log = LogFactory.getLog(ImageLoaderImageIO.class);
    private ImageFlavor targetFlavor;
    private static final String PNG_METADATA_NODE = "javax_imageio_png_1.0";
    private static final String JPEG_METADATA_NODE = "javax_imageio_jpeg_image_1.0";
    private static final Set providersIgnoringICC = new HashSet();

    public ImageLoaderImageIO(ImageFlavor imageFlavor) {
        if (!ImageFlavor.BUFFERED_IMAGE.equals(imageFlavor) && !ImageFlavor.RENDERED_IMAGE.equals(imageFlavor)) {
            throw new IllegalArgumentException("Unsupported target ImageFlavor: " + imageFlavor);
        }
        this.targetFlavor = imageFlavor;
    }

    public ImageFlavor getTargetFlavor() {
        return this.targetFlavor;
    }

    /*
     * Exception decompiling
     */
    public Image loadImage(ImageInfo var1_1, Map var2_2, ImageSessionContext var3_3) throws ImageException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkProviderIgnoresICC(IIOServiceProvider iIOServiceProvider) {
        StringBuffer stringBuffer = new StringBuffer(iIOServiceProvider.getDescription(Locale.ENGLISH));
        stringBuffer.append('/').append(iIOServiceProvider.getVendorName());
        stringBuffer.append('/').append(iIOServiceProvider.getVersion());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Image Provider: " + stringBuffer.toString()));
        }
        return providersIgnoringICC.contains(stringBuffer.toString());
    }

    private ICC_Profile tryToExctractICCProfile(IIOMetadata iIOMetadata) {
        ICC_Profile iCC_Profile = null;
        String[] stringArray = iIOMetadata.getMetadataFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Element element = (Element)iIOMetadata.getAsTree(string);
            if (PNG_METADATA_NODE.equals(string)) {
                iCC_Profile = this.tryToExctractICCProfileFromPNGMetadataNode(element);
                continue;
            }
            if (!JPEG_METADATA_NODE.equals(string)) continue;
            iCC_Profile = this.tryToExctractICCProfileFromJPEGMetadataNode(element);
        }
        return iCC_Profile;
    }

    private ICC_Profile tryToExctractICCProfileFromPNGMetadataNode(Element element) {
        ICC_Profile iCC_Profile = null;
        Element element2 = ImageIOUtil.getChild(element, "iCCP");
        if (element2 instanceof IIOMetadataNode) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)element2;
            byte[] byArray = (byte[])iIOMetadataNode.getUserObject();
            String string = iIOMetadataNode.getAttribute("compressionMethod");
            if ("deflate".equalsIgnoreCase(string)) {
                Inflater inflater = new Inflater();
                inflater.setInput(byArray);
                byte[] byArray2 = new byte[100];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                boolean bl = false;
                while (!inflater.finished() && !bl) {
                    try {
                        int n = inflater.inflate(byArray2);
                        byteArrayOutputStream.write(byArray2, 0, n);
                        if (n != 0) continue;
                        log.debug((Object)"Failed to deflate ICC Profile");
                        bl = true;
                    }
                    catch (DataFormatException dataFormatException) {
                        log.debug((Object)"Failed to deflate ICC Profile", (Throwable)dataFormatException);
                        bl = true;
                    }
                }
                inflater.end();
                try {
                    iCC_Profile = ColorProfileUtil.getICC_Profile(byteArrayOutputStream.toByteArray());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.debug((Object)"Failed to interpret embedded ICC Profile", (Throwable)illegalArgumentException);
                    iCC_Profile = null;
                }
            }
        }
        return iCC_Profile;
    }

    private ICC_Profile tryToExctractICCProfileFromJPEGMetadataNode(Element element) {
        Element element2;
        ICC_Profile iCC_Profile = null;
        Element element3 = ImageIOUtil.getChild(element, "app0JFIF");
        if (element3 != null && (element2 = ImageIOUtil.getChild(element3, "app2ICC")) instanceof IIOMetadataNode) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)element2;
            iCC_Profile = (ICC_Profile)iIOMetadataNode.getUserObject();
        }
        return iCC_Profile;
    }

    private BufferedImage getFallbackBufferedImage(ImageReader imageReader, int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        Raster raster = imageReader.readRaster(n, imageReadParam);
        int n3 = raster.getNumBands();
        switch (n3) {
            case 1: {
                n2 = 10;
                break;
            }
            case 3: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 6;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported band count: " + n3);
            }
        }
        BufferedImage bufferedImage = new BufferedImage(raster.getWidth(), raster.getHeight(), n2);
        bufferedImage.getRaster().setRect(raster);
        return bufferedImage;
    }

    static {
        providersIgnoringICC.add("Standard PNG image reader/Sun Microsystems, Inc./1.0");
        providersIgnoringICC.add("Standard JPEG Image Reader/Sun Microsystems, Inc./0.5");
    }
}

