/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer.internal;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.tiff.TIFFImageEncoder;
import org.apache.xmlgraphics.image.writer.AbstractImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;

public class TIFFImageWriter
extends AbstractImageWriter {
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        this.writeImage(renderedImage, outputStream, null);
    }

    public void writeImage(RenderedImage renderedImage, OutputStream outputStream, ImageWriterParams imageWriterParams) throws IOException {
        TIFFEncodeParam tIFFEncodeParam = this.createTIFFEncodeParams(imageWriterParams);
        TIFFImageEncoder tIFFImageEncoder = new TIFFImageEncoder(outputStream, tIFFEncodeParam);
        tIFFImageEncoder.encode(renderedImage);
    }

    private TIFFEncodeParam createTIFFEncodeParams(ImageWriterParams imageWriterParams) {
        TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
        if (imageWriterParams == null) {
            tIFFEncodeParam.setCompression(1);
        } else {
            if (imageWriterParams.getCompressionMethod() == null) {
                tIFFEncodeParam.setCompression(32773);
            } else if ("PackBits".equalsIgnoreCase(imageWriterParams.getCompressionMethod())) {
                tIFFEncodeParam.setCompression(32773);
            } else if ("NONE".equalsIgnoreCase(imageWriterParams.getCompressionMethod())) {
                tIFFEncodeParam.setCompression(1);
            } else if ("Deflate".equalsIgnoreCase(imageWriterParams.getCompressionMethod())) {
                tIFFEncodeParam.setCompression(32946);
            } else {
                throw new UnsupportedOperationException("Compression method not supported: " + imageWriterParams.getCompressionMethod());
            }
            if (imageWriterParams.getResolution() != null) {
                float f = 25.4f / imageWriterParams.getResolution().floatValue();
                int n = (int)((double)(100000.0f / f) + 0.5);
                int n2 = 10000;
                long[] lArray = new long[]{n, n2};
                TIFFField[] tIFFFieldArray = new TIFFField[]{new TIFFField(296, 3, 1, new char[]{'\u0003'}), new TIFFField(282, 5, 1, new long[][]{lArray}), new TIFFField(283, 5, 1, new long[][]{lArray})};
                tIFFEncodeParam.setExtraFields(tIFFFieldArray);
            }
        }
        return tIFFEncodeParam;
    }

    public String getMIMEType() {
        return "image/tiff";
    }

    public MultiImageWriter createMultiImageWriter(OutputStream outputStream) throws IOException {
        return new TIFFMultiImageWriter(outputStream);
    }

    public boolean supportsMultiImageWriter() {
        return true;
    }

    private class TIFFMultiImageWriter
    implements MultiImageWriter {
        private OutputStream out;
        private TIFFEncodeParam encodeParams;
        private TIFFImageEncoder encoder;
        private Object context;

        public TIFFMultiImageWriter(OutputStream outputStream) throws IOException {
            this.out = outputStream;
        }

        public void writeImage(RenderedImage renderedImage, ImageWriterParams imageWriterParams) throws IOException {
            if (this.encoder == null) {
                this.encodeParams = TIFFImageWriter.this.createTIFFEncodeParams(imageWriterParams);
                this.encoder = new TIFFImageEncoder(this.out, this.encodeParams);
            }
            this.context = this.encoder.encodeMultiple(this.context, renderedImage);
        }

        public void close() throws IOException {
            if (this.encoder != null) {
                this.encoder.finishMultiple(this.context);
            }
            this.encoder = null;
            this.encodeParams = null;
            this.out.flush();
        }
    }
}

