/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollBar;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSlider;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJTree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class BareSwingDetector {
    private static boolean sIsInitialized;
    private static boolean sIsEnabled;
    private static boolean sUIsInstalled;
    private static String[] sExemptions;
    private static volatile int sExemptionDepth;
    private static String sOriginalButtonUIName;
    private static String sOriginalCheckBoxUIName;
    private static String sOriginalComboBoxUIName;
    private static String sOriginalLabelUIName;
    private static String sOriginalListUIName;
    private static String sOriginalOptionPaneUIName;
    private static String sOriginalPopupMenuUIName;
    private static String sOriginalProgressBarUIName;
    private static String sOriginalRadioButtonUIName;
    private static String sOriginalScrollBarUIName;
    private static String sOriginalScrollPaneUIName;
    private static String sOriginalSliderUIName;
    private static String sOriginalSpinnerUIName;
    private static String sOriginalSplitPaneUIName;
    private static String sOriginalTabbedPaneUIName;
    private static String sOriginalTableUIName;
    private static String sOriginalTextFieldUIName;
    private static String sOriginalToggleButtonUIName;
    private static String sOriginalToolBarUIName;
    private static String sOriginalTreeUIName;
    private static final String EXEMPTION_FILE_NAME = "swingexemptions.txt";

    static synchronized void init() {
        sIsInitialized = true;
        String string = System.getProperty("mathworks.WarnIfBareSwing");
        if (string != null) {
            sIsEnabled = string.equalsIgnoreCase("true");
        }
        if (sIsEnabled) {
            BareSwingDetector.setEnabled(true);
        }
    }

    public static synchronized boolean isEnabled() {
        return sIsEnabled;
    }

    public static synchronized void setEnabled(boolean bl) {
        if (bl && sIsInitialized) {
            if (!sUIsInstalled) {
                sOriginalButtonUIName = (String)UIManager.get("ButtonUI");
                sOriginalCheckBoxUIName = (String)UIManager.get("CheckBoxUI");
                sOriginalComboBoxUIName = (String)UIManager.get("ComboBoxUI");
                sOriginalLabelUIName = (String)UIManager.get("LabelUI");
                sOriginalListUIName = (String)UIManager.get("ListUI");
                sOriginalOptionPaneUIName = (String)UIManager.get("OptionPaneUI");
                sOriginalPopupMenuUIName = (String)UIManager.get("PopupMenuUI");
                sOriginalProgressBarUIName = (String)UIManager.get("ProgressBarUI");
                sOriginalRadioButtonUIName = (String)UIManager.get("RadioButtonUI");
                sOriginalScrollPaneUIName = (String)UIManager.get("ScrollBarUI");
                sOriginalScrollPaneUIName = (String)UIManager.get("ScrollPaneUI");
                sOriginalSliderUIName = (String)UIManager.get("SliderUI");
                sOriginalSpinnerUIName = (String)UIManager.get("SpinnerUI");
                sOriginalSplitPaneUIName = (String)UIManager.get("SplitPaneUI");
                sOriginalTabbedPaneUIName = (String)UIManager.get("TabbedPaneUI");
                sOriginalTableUIName = (String)UIManager.get("TableUI");
                sOriginalTextFieldUIName = (String)UIManager.get("TextFieldUI");
                sOriginalToggleButtonUIName = (String)UIManager.get("ToggleButtonUI");
                sOriginalToolBarUIName = (String)UIManager.get("ToolBarUI");
                sOriginalTreeUIName = (String)UIManager.get("TreeUI");
                UIManager.put("ButtonUI", "com.mathworks.mwswing.BareSwingDetector$ButtonDetectorUI");
                UIManager.put("CheckBoxUI", "com.mathworks.mwswing.BareSwingDetector$CheckBoxDetectorUI");
                UIManager.put("ComboBoxUI", "com.mathworks.mwswing.BareSwingDetector$ComboBoxDetectorUI");
                UIManager.put("LabelUI", "com.mathworks.mwswing.BareSwingDetector$LabelDetectorUI");
                UIManager.put("ListUI", "com.mathworks.mwswing.BareSwingDetector$ListDetectorUI");
                UIManager.put("OptionPaneUI", "com.mathworks.mwswing.BareSwingDetector$OptionPaneDetectorUI");
                UIManager.put("PopupMenuUI", "com.mathworks.mwswing.BareSwingDetector$PopupMenuDetectorUI");
                UIManager.put("ProgressBarUI", "com.mathworks.mwswing.BareSwingDetector$ProgressBarDetectorUI");
                UIManager.put("RadioButtonUI", "com.mathworks.mwswing.BareSwingDetector$RadioButtonDetectorUI");
                UIManager.put("ScrollBarUI", "com.mathworks.mwswing.BareSwingDetector$ScrollBarDetectorUI");
                UIManager.put("ScrollPaneUI", "com.mathworks.mwswing.BareSwingDetector$ScrollPaneDetectorUI");
                UIManager.put("SliderUI", "com.mathworks.mwswing.BareSwingDetector$SliderDetectorUI");
                UIManager.put("SpinnerUI", "com.mathworks.mwswing.BareSwingDetector$SpinnerDetectorUI");
                UIManager.put("SplitPaneUI", "com.mathworks.mwswing.BareSwingDetector$SplitPaneDetectorUI");
                UIManager.put("TabbedPaneUI", "com.mathworks.mwswing.BareSwingDetector$TabbedPaneDetectorUI");
                UIManager.put("TableUI", "com.mathworks.mwswing.BareSwingDetector$TableDetectorUI");
                UIManager.put("TextFieldUI", "com.mathworks.mwswing.BareSwingDetector$TextFieldDetectorUI");
                UIManager.put("ToggleButtonUI", "com.mathworks.mwswing.BareSwingDetector$ToggleButtonDetectorUI");
                UIManager.put("ToolBarUI", "com.mathworks.mwswing.BareSwingDetector$ToolBarDetectorUI");
                UIManager.put("TreeUI", "com.mathworks.mwswing.BareSwingDetector$TreeDetectorUI");
            }
            sUIsInstalled = true;
            if (sExemptions == null) {
                BareSwingDetector.loadExemptions();
            }
        }
        sIsEnabled = bl;
    }

    public static void exempt() {
        ++sExemptionDepth;
    }

    public static void reinstate() {
        --sExemptionDepth;
    }

    private static final boolean shouldWarn() {
        return sIsEnabled && sExemptionDepth == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadExemptions() {
        File file;
        ArrayList arrayList = new ArrayList();
        URL uRL = BareSwingDetector.class.getResource("resources/swingexemptions.txt");
        BufferedReader bufferedReader = null;
        if (uRL != null) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                BareSwingDetector.readExemptions(bufferedReader, arrayList);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((file = new File(EXEMPTION_FILE_NAME)).exists()) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                BareSwingDetector.readExemptions(bufferedReader, arrayList);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (arrayList.size() > 0) {
            sExemptions = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    private static void readExemptions(BufferedReader bufferedReader, List list) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.length() > 0 && string.charAt(0) != '#') {
                list.add(string);
            }
            string = bufferedReader.readLine();
        }
    }

    private static ComponentUI createRealUI(JComponent jComponent, String string) {
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{JComponent.class};
                Method method = clazz.getMethod("createUI", classArray);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    Object[] objectArray = new Object[]{jComponent};
                    return (ComponentUI)method.invoke(null, objectArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return UIManager.getLookAndFeelDefaults().getUI(jComponent);
    }

    public static class TreeDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJTree)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalTreeUIName);
        }
    }

    public static class ToolBarDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJToolBar)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalToolBarUIName);
        }
    }

    public static class ToggleButtonDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJToggleButton)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalToggleButtonUIName);
        }
    }

    public static class TextFieldDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (!(!BareSwingDetector.shouldWarn() || jComponent instanceof MJTextField || jComponent instanceof MJFormattedTextField || jComponent instanceof TableCellEditor || jComponent instanceof TreeCellEditor)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalTextFieldUIName);
        }
    }

    public static class TableDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJTable)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalTableUIName);
        }
    }

    public static class TabbedPaneDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJTabbedPane)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalTabbedPaneUIName);
        }
    }

    public static class SplitPaneDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJSplitPane)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalSplitPaneUIName);
        }
    }

    public static class SpinnerDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJSpinner)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalSpinnerUIName);
        }
    }

    public static class SliderDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJSlider)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalSliderUIName);
        }
    }

    public static class ScrollPaneDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJScrollPane)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalScrollPaneUIName);
        }
    }

    public static class ScrollBarDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJScrollBar)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalScrollBarUIName);
        }
    }

    public static class RadioButtonDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJRadioButton)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalRadioButtonUIName);
        }
    }

    public static class ProgressBarDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJProgressBar)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalProgressBarUIName);
        }
    }

    public static class PopupMenuDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJPopupMenu)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalPopupMenuUIName);
        }
    }

    public static class OptionPaneDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJOptionPane)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalOptionPaneUIName);
        }
    }

    public static class ListDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJList)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalListUIName);
        }
    }

    public static class LabelDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (!(!BareSwingDetector.shouldWarn() || jComponent instanceof MJLabel || jComponent instanceof ListCellRenderer || jComponent instanceof TableCellRenderer || jComponent instanceof TreeCellRenderer)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalLabelUIName);
        }
    }

    public static class ComboBoxDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJComboBox)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalComboBoxUIName);
        }
    }

    public static class CheckBoxDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (!(!BareSwingDetector.shouldWarn() || jComponent instanceof MJCheckBox || jComponent instanceof ListCellRenderer || jComponent instanceof TableCellRenderer || jComponent instanceof TreeCellRenderer)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalCheckBoxUIName);
        }
    }

    public static class ButtonDetectorUI
    extends ComponentUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (BareSwingDetector.shouldWarn() && !(jComponent instanceof MJButton) && !(jComponent instanceof BasicArrowButton)) {
                new BareSwingWarning().issue();
            }
            return BareSwingDetector.createRealUI(jComponent, sOriginalButtonUIName);
        }
    }

    static class BareSwingWarning
    extends Throwable {
        public BareSwingWarning() {
            super("Creating a Swing component that is not an instance of the corresponding com.mathwork.mwswing subclass");
        }

        void issue() {
            if (sExemptions != null) {
                StackTraceElement[] stackTraceElementArray = this.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    for (int j = 0; j < sExemptions.length; ++j) {
                        if (!stackTraceElementArray[i].toString().startsWith(sExemptions[j])) continue;
                        return;
                    }
                }
            }
            this.printStackTrace(System.out);
        }
    }
}

