/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class MJMenuBar
extends JMenuBar {
    private boolean fMoreMenuEnabled;
    private MJMenu fMoreMenu;
    private int fOverflowIndex = -1;

    public MJMenuBar() {
        this.setMoreMenuEnabled(!PlatformInfo.isMacintosh());
    }

    public void dispose() {
        MJMenuBar.dispose(this);
    }

    public static void dispose(JMenuBar jMenuBar) {
        int n = jMenuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (jMenu instanceof MJMenu) {
                ((MJMenu)jMenu).dispose();
                continue;
            }
            if (jMenu == null) continue;
            MJMenu.dispose(jMenu);
        }
    }

    public void setMoreMenuEnabled(boolean bl) {
        if (this.fMoreMenuEnabled != bl) {
            this.fMoreMenuEnabled = bl;
            if (bl) {
                this.fMoreMenu = new MJMenu();
                if (PlatformInfo.isWindowsVistaAppearance()) {
                    this.fMoreMenu.setText("\u00bb");
                } else {
                    this.fMoreMenu.setIcon(new ImageIcon(MJMenuBar.class.getResource("resources/more.gif")));
                }
                this.fMoreMenu.setEnabled(false);
                if (this.isDisplayable()) {
                    this.addMoreMenu();
                }
            } else if (this.fMoreMenu != null) {
                if (this.fMoreMenu.getParent() != null) {
                    super.remove(this.fMoreMenu);
                }
                if (this.fOverflowIndex != -1) {
                    while (this.fMoreMenu.getMenuComponentCount() > 0) {
                        MJMenuBar.addAndCorrect(this, this.fMoreMenu.getMenuComponent(0), -1);
                    }
                    this.fOverflowIndex = -1;
                }
                this.fMoreMenu = null;
            }
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    public boolean hasMoreMenu() {
        return this.fMoreMenu != null && this.fMoreMenu.getParent() != null;
    }

    public boolean isMoreMenuEnabled() {
        return this.fMoreMenuEnabled;
    }

    @Override
    public void doLayout() {
        if (!this.fMoreMenuEnabled || this.getWidth() <= 0 || this.getHeight() <= 0) {
            try {
                super.doLayout();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return;
        }
        if (!this.hasMoreMenu()) {
            this.addMoreMenu();
        }
        Insets insets = this.getInsets();
        int n = this.getHeight() - insets.top - insets.bottom;
        int n2 = this.getMenuCount() + this.fMoreMenu.getMenuComponentCount() - 1;
        if (n2 > 0) {
            int n3;
            int n4 = -1;
            int n5 = this.getWidth();
            int n6 = insets.left;
            for (int i = 0; i < n2 && n4 == -1; ++i) {
                JMenu jMenu;
                if (i < this.getComponentCount() - 1) {
                    jMenu = this.getMenu(i);
                } else {
                    jMenu = (JMenu)this.fMoreMenu.getMenuComponent(i - this.getComponentCount() + 1);
                    MJMenuBar.addAndCorrect(this, jMenu, this.getComponentCount() - 1);
                }
                int n7 = n3 = jMenu.isVisible() ? jMenu.getPreferredSize().width : 0;
                if (n6 + n3 > n5 - insets.right) {
                    n4 = i;
                    continue;
                }
                jMenu.setBounds(n6, insets.top, n3, n);
                n6 += n3;
            }
            this.fMoreMenu.setEnabled(n4 != -1);
            if (n4 == -1) {
                this.fMoreMenu.setBounds(this.getWidth() + 1, 0, 0, 0);
            } else {
                Dimension dimension = this.fMoreMenu.getPreferredSize();
                int n8 = n5 - insets.right - dimension.width;
                this.fMoreMenu.setBounds(n8, insets.top, dimension.width, n);
                if (n6 > n8 && n4 > 0) {
                    --n4;
                }
                n3 = 0;
                while (this.getComponentCount() > n4 + 1) {
                    MJMenuBar.addAndCorrect(this.fMoreMenu, this.getComponent(n4), n3++);
                }
            }
            this.fOverflowIndex = n4;
        }
    }

    private void addMoreMenu() {
        this.add(this.fMoreMenu);
        if (PlafUtils.isPlasticLookAndFeel()) {
            this.fMoreMenu.updateUI();
        }
    }

    private static void addAndCorrect(JComponent jComponent, Component component, int n) {
        jComponent.add(component, n);
        if (PlafUtils.isPlasticLookAndFeel() && component instanceof JMenu) {
            JMenu jMenu = (JMenu)component;
            jMenu.updateUI();
            jMenu.setOpaque(!jMenu.isTopLevelMenu());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(super.getPreferredSize());
        if (this.fMoreMenu != null) {
            dimension.width -= this.fMoreMenu.getPreferredSize().width;
        }
        return dimension;
    }

    @Override
    public void removeAll() {
        boolean bl = this.hasMoreMenu();
        super.removeAll();
        if (this.fMoreMenu != null) {
            this.fMoreMenu.removeAll();
            if (bl) {
                this.addMoreMenu();
            }
        }
    }
}

