/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.binding.AbstractNamedUniqueID;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.ContextActionData;
import com.mathworks.mwswing.binding.ContextID;
import com.mathworks.mwswing.binding.DefaultKeyBindingSetID;
import com.mathworks.mwswing.binding.KeyStrokeList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class Context
extends AbstractNamedUniqueID
implements ContextID,
Comparable<Context> {
    public static final Context GLOBAL = new Context("Global", "Global", false);
    public static final Context NONE = new Context("None", "None", false);
    private Collection<ContextActionData> fSupportedActions = Collections.emptyList();
    private final boolean fSupportsActions;

    Context(String string, String string2, Collection<ContextActionData> collection) {
        this(string, string2, true, collection);
    }

    private Context(String string, String string2) {
        this(string, string2, Collections.emptyList());
    }

    private Context(String string, String string2, boolean bl) {
        this(string, string2, bl, Collections.emptyList());
    }

    private Context(String string, String string2, boolean bl, Collection<ContextActionData> collection) {
        super(string, string2);
        this.fSupportsActions = bl;
        assert (collection != null) : "List of supported actions must be non-null (can be empty though).";
        if (!this.fSupportsActions) assert (collection.isEmpty());
        this.fSupportedActions = new LinkedList<ContextActionData>(collection);
    }

    public boolean isSupportedAction(ActionDataID actionDataID) throws UnsupportedOperationException {
        return this.privateGetContextAction(actionDataID) != null;
    }

    private ContextActionData privateGetContextAction(ActionDataID actionDataID) {
        this.checkSupportedOp();
        for (ContextActionData contextActionData : this.fSupportedActions) {
            if (!contextActionData.getAction().getID().equals(actionDataID.getID())) continue;
            return contextActionData;
        }
        return null;
    }

    public Collection<ContextActionData> getSupportedActions() {
        return Collections.unmodifiableCollection(this.fSupportedActions);
    }

    public ContextActionData getContextAction(ActionDataID actionDataID) throws UnsupportedOperationException, IllegalStateException {
        ContextActionData contextActionData = this.privateGetContextAction(actionDataID);
        if (contextActionData == null) {
            throw new IllegalStateException("Context '" + this + "' does not support ActionData '" + actionDataID + "'.");
        }
        return contextActionData;
    }

    public List<KeyStrokeList> getKeyBindings(ActionDataID actionDataID, DefaultKeyBindingSetID defaultKeyBindingSetID) throws UnsupportedOperationException, IllegalStateException {
        this.checkSupportedOp();
        ContextActionData contextActionData = this.getContextAction(actionDataID);
        return contextActionData.getKeyBindings(defaultKeyBindingSetID);
    }

    private void checkSupportedOp() throws UnsupportedOperationException {
        if (!this.supportsActions()) {
            throw new UnsupportedOperationException("Operation not supported for context " + this);
        }
    }

    public boolean supportsActions() {
        return this.fSupportsActions;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Context)) {
            return false;
        }
        Context context = (Context)object;
        return context.getID().equals(this.getID());
    }

    public int hashCode() {
        return 629 + this.getID().hashCode();
    }

    static boolean areCompletelyEquivalent(Context context, Context context2) {
        boolean bl;
        boolean bl2 = bl = context.getID().equals(context2.getID()) && context.getName().equals(context2.getName()) && context.supportsActions() == context2.supportsActions();
        if (bl && context.fSupportedActions.size() == context2.fSupportedActions.size()) {
            Iterator<ContextActionData> iterator = context.fSupportedActions.iterator();
            Iterator<ContextActionData> iterator2 = context2.fSupportedActions.iterator();
            while (iterator.hasNext() && bl) {
                bl = ContextActionData.areCompletelyEquivalent(iterator.next(), iterator2.next());
            }
        }
        return bl;
    }

    @Override
    public int compareTo(Context context) {
        return this.getName().compareTo(context.getName());
    }
}

