/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.CustomKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistry;
import com.mathworks.mwswing.binding.KeyBindingReaderUtils;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.ReadWriteException;
import java.io.InputStream;
import java.util.List;

public final class CustomKeyBindingSetReader {
    private final CustomKeyBindingSet fCustomSet;
    private final KeyBindingManagerRegistry fRegistry;

    public CustomKeyBindingSetReader(String string, String string2, InputStream inputStream, KeyBindingManagerRegistry keyBindingManagerRegistry) throws ReadWriteException {
        SimpleElement simpleElement;
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        if (keyBindingManagerRegistry == null) {
            throw new IllegalArgumentException("KeyBindingManagerRegistry cannot be null");
        }
        try {
            simpleElement = KeyBindingReaderUtils.getTopElement(inputStream, "CustomKeySet");
        }
        catch (ReadWriteException readWriteException) {
            throw new ReadWriteException(readWriteException, readWriteException.getState(), "reader.error.genericReadingError", string);
        }
        this.fRegistry = keyBindingManagerRegistry;
        String string3 = simpleElement.getAttribute("derivedfrom");
        String string4 = simpleElement.getAttribute("modifieddefault");
        boolean bl = string4 != null && Boolean.valueOf(string4) != false;
        this.fCustomSet = new CustomKeyBindingSet(string2, this.fRegistry.getDefaultKeyBindingSet(string3), string, bl);
        SimpleNodeList simpleNodeList = simpleElement.getElementsByTagName("Context");
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            this.addContextInfo((SimpleElement)simpleNodeList.item(i));
        }
    }

    private void addContextInfo(SimpleElement simpleElement) throws ReadWriteException {
        String string = simpleElement.getAttribute("id");
        if (this.fRegistry.containsContext(string)) {
            SimpleNodeList simpleNodeList = simpleElement.getChildNodes();
            for (int i = 0; i < simpleNodeList.getLength(); ++i) {
                String string2;
                SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
                if (simpleElement2 == null || !simpleElement2.getNodeName().equals("Action") || !this.fRegistry.containsAction(string2 = simpleElement2.getAttribute("id"))) continue;
                ActionData actionData = this.fRegistry.getActionData(string2);
                Context context = this.fRegistry.getContext(string);
                List<KeyStrokeList> list = KeyBindingReaderUtils.createKeyBindings(simpleElement2);
                if (Context.GLOBAL.getID().equals(string)) {
                    this.fCustomSet.addGlobalBindings(actionData, list);
                    continue;
                }
                String string3 = simpleElement2.getAttribute("follows");
                if (string3 == null) {
                    this.fCustomSet.setCustomKeyBindings(context, actionData, true, list);
                    continue;
                }
                if (string3.equals(Context.NONE.getID())) {
                    this.fCustomSet.setCustomKeyBindings(context, actionData, false, list);
                    continue;
                }
                throw new ReadWriteException(ReadWriteException.IOErrorType.READ_UNKNOWN, "reader.error.customContext", context.getID());
            }
        }
    }

    public CustomKeyBindingSet getKeyBindingSet() {
        return this.fCustomSet;
    }
}

