/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.ComponentPositionListener;
import com.mathworks.hg.peer.FigureBoundsNotification;
import com.mathworks.hg.peer.FigureInsetsUtilities;
import com.mathworks.hg.peer.IPositionable;
import com.mathworks.hg.peer.ObservableFigurePanel;
import com.mathworks.hg.peer.OffscreenWindowProvider;
import com.mathworks.hg.peer.PaintDisabled;
import com.mathworks.hg.peer.PositionDataInDevice;
import com.mathworks.hg.peer.PositionListener;
import com.mathworks.hg.peer.PositionableFigureClientProxy;
import com.mathworks.hg.peer.WindowRectHandlerImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class FigurePositionableProxy
implements IPositionable {
    private PositionableFigureClientProxy fFigureClient = null;
    private ObservableFigurePanel fFigurePanel = null;
    private int fToolbarHeight = 0;
    private int fMenubarHeight = 0;
    private int fJavaCompWest = 0;
    private int fJavaCompNorth = 0;
    private int fJavaCompEast = 0;
    private int fJavaCompSouth = 0;
    boolean fResizableFrame = true;

    public void setFigureClient(PositionableFigureClientProxy positionableFigureClientProxy) {
        this.fFigureClient = positionableFigureClientProxy;
    }

    public void setFigurePanel(ObservableFigurePanel observableFigurePanel) {
        this.fFigurePanel = observableFigurePanel;
    }

    public void setResizable(boolean bl) {
        this.fResizableFrame = bl;
    }

    @Override
    public void addPositionListener(PositionListener positionListener) {
        assert (false);
    }

    @Override
    public void removePositionListener(PositionListener positionListener) {
        assert (false);
    }

    @Override
    public PositionDataInDevice getPositionInDevice() {
        if (!this.areFigurePanelContainerBoundsValid()) {
            return null;
        }
        return this.constructPosDataInDeviceOnMoveResize();
    }

    private Insets getWindowInsets() {
        Insets insets;
        Container container = this.fFigurePanel.getContainer();
        Window window = SwingUtilities.getWindowAncestor(container);
        if (window != null && !OffscreenWindowProvider.isComponentInOffscreenWindow(window) && (insets = FigureInsetsUtilities.getWindowInsets(window)) != null) {
            return insets;
        }
        return this.getInsetsForInvisibleWindow();
    }

    private Insets getInsetsForInvisibleWindow() {
        Insets insets = this.fResizableFrame ? FigureInsetsUtilities.getCachedResizableFrameInsets() : FigureInsetsUtilities.getCachedNonResizableFrameInsets();
        insets = FigureInsetsUtilities.validateInsets(insets, this.fResizableFrame);
        return insets;
    }

    private Insets getInsets() {
        Insets insets;
        if (this.fFigureClient.isClientDocked()) {
            insets = this.fFigureClient.getDockedClientInsets();
        } else {
            insets = this.getWindowInsets();
            insets.top = insets.top + this.fMenubarHeight + this.fToolbarHeight;
        }
        return new Insets(insets.top + this.fJavaCompNorth, insets.left + this.fJavaCompWest, insets.bottom + this.fJavaCompSouth, insets.right + this.fJavaCompEast);
    }

    @Override
    public void doSetPosition(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        boolean bl = PaintDisabled.isChildOfPaintDisabledContainer(this.fFigurePanel.getContainer());
        if (!bl && !this.fFigureClient.isClientDocked()) {
            rectangle2 = WindowRectHandlerImpl.adjustWindowOuterBoundsForScreenLimits(rectangle2);
        }
        Rectangle rectangle3 = new Rectangle(this.fFigureClient.getClientRectangle());
        this.fFigureClient.setClientRectangle(rectangle2);
        if (!rectangle2.equals(rectangle) || rectangle3.equals(rectangle2)) {
            PositionDataInDevice positionDataInDevice = this.getPositionInDeviceFromOuterBoundsForVisAndInvisFigure();
            this.fireFigureBoundsNotification(positionDataInDevice);
        }
    }

    @Override
    public ComponentPositionListener createPeerPositionListener() {
        return new FigureComponentPositionListener();
    }

    @Override
    public void addPeerPositionListener(ComponentPositionListener componentPositionListener) {
        this.fFigurePanel.addContainerPositionListener(componentPositionListener);
    }

    @Override
    public void removePeerPositionListener(ComponentPositionListener componentPositionListener) {
        this.fFigurePanel.removeContainerPositionListener(componentPositionListener);
    }

    private boolean areFigurePanelContainerBoundsValid() {
        Container container = this.fFigurePanel.getContainer();
        return container != null && container.isDisplayable() && container.isValid();
    }

    private void handleBoundsChange() {
        PositionDataInDevice positionDataInDevice = this.getPositionInDevice();
        this.fireFigureBoundsNotification(positionDataInDevice);
    }

    private void fireFigureBoundsNotification(PositionDataInDevice positionDataInDevice) {
        if (positionDataInDevice != null) {
            FigureBoundsNotification figureBoundsNotification = new FigureBoundsNotification(positionDataInDevice);
            this.fFigureClient.handleNotification(figureBoundsNotification);
        }
    }

    private PositionDataInDevice getPositionInDeviceFromOuterBoundsForVisAndInvisFigure() {
        Rectangle rectangle = this.fFigureClient.getClientRectangle();
        Insets insets = this.getInsets();
        return new PositionDataInDevice(rectangle, insets);
    }

    protected PositionDataInDevice getPositionInDeviceFromOuterBounds() {
        if (!this.areFigurePanelContainerBoundsValid()) {
            return null;
        }
        return this.getPositionInDeviceFromOuterBoundsForVisAndInvisFigure();
    }

    void handleOuterBoundsChange() {
        PositionDataInDevice positionDataInDevice = this.getPositionInDeviceFromOuterBounds();
        this.fireFigureBoundsNotification(positionDataInDevice);
    }

    private Point determineXYOffsetForInnerBounds(Container container) {
        Point point = new Point(0, 0);
        Container container2 = container;
        Window window = SwingUtilities.getWindowAncestor(container);
        do {
            if ((container2 = container2.getParent()) == null) continue;
            Point point2 = container2.getLocation();
            point.translate(point2.x, point2.y);
        } while (container2 != null && !container2.equals(window));
        return point;
    }

    private PositionDataInDevice constructPosDataInDeviceOnMoveResize() {
        Object object;
        assert (SwingUtilities.isEventDispatchThread()) : "Must call FigurePositionableProxy::constructPosDataInDeviceOnMoveResize on EDT";
        Rectangle rectangle = this.fFigureClient.getClientRectangle();
        Insets insets = null;
        if (this.fFigureClient.isClientDocked()) {
            insets = this.fFigureClient.getDockedClientInsets();
        } else {
            object = this.fFigurePanel.getContainer();
            Rectangle rectangle2 = ((Component)object).getBounds();
            Point point = this.determineXYOffsetForInnerBounds((Container)object);
            rectangle2.translate(point.x, point.y);
            insets = PositionDataInDevice.calculateInsetsFromOuterAndInnerBounds(rectangle, rectangle2);
        }
        object = null;
        if (insets.top >= 0 && insets.left >= 0 && insets.bottom >= 0 && insets.right >= 0) {
            object = new PositionDataInDevice(rectangle, insets);
        }
        return object;
    }

    void setToolbarHeight(int n) {
        this.fToolbarHeight = n;
    }

    void setMenubarHeight(int n) {
        this.fMenubarHeight = n;
    }

    void handleJavaComponentMarginChange(int n, int n2) {
        switch (n2) {
            case 0: {
                this.fJavaCompNorth = n;
                break;
            }
            case 1: {
                this.fJavaCompSouth = n;
                break;
            }
            case 3: {
                this.fJavaCompWest = n;
                break;
            }
            case 2: {
                this.fJavaCompEast = n;
                break;
            }
            default: {
                throw new AssertionError(n2);
            }
        }
    }

    private class FigureComponentPositionListener
    extends ComponentPositionListener {
        @Override
        protected void positionChanged() {
            FigurePositionableProxy.this.handleBoundsChange();
        }
    }
}

