/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import com.mathworks.hg.uij.OpenGLUtils;
import com.mathworks.mwswing.binding.KeySequenceDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.awt.GLCanvas;

public class JavaSceneServerGLCanvas
extends GLCanvas
implements FigureComponent,
KeySequenceDispatcher.IgnoresAncestorKeyBindings {
    private JavaSceneServerPeerInterface fJSSP;
    private boolean fInSetup;

    public JavaSceneServerGLCanvas(GLCapabilities gLCapabilities, JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        super((GLCapabilitiesImmutable)gLCapabilities);
        this.fJSSP = javaSceneServerPeerInterface;
        this.fInSetup = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        try {
            JavaSceneServerGLCanvas.enterCriticalSection();
            this.fJSSP.predraw();
            try {
                OpenGLUtils.throwIfRequested();
                super.paint(graphics);
            }
            catch (GLException gLException) {
                this.fJSSP.reportGLException(gLException);
            }
            this.fJSSP.postdraw();
        }
        finally {
            JavaSceneServerGLCanvas.exitCriticalSection();
        }
    }

    public void setupPrint(double d, double d2, int n, int n2, int n3) {
        try {
            JavaSceneServerGLCanvas.enterCriticalSection();
            OpenGLUtils.throwIfRequested();
            super.setupPrint(d, d2, n, n2, n3);
            this.fInSetup = true;
        }
        catch (GLException gLException) {
            this.fJSSP.reportGLException(gLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePrint() {
        try {
            OpenGLUtils.throwIfRequested();
            super.releasePrint();
        }
        catch (GLException gLException) {
            this.fJSSP.reportGLException(gLException);
        }
        finally {
            this.fInSetup = false;
            JavaSceneServerGLCanvas.exitCriticalSection();
        }
    }

    public void print(Graphics graphics) {
        if (this.fInSetup) {
            super.print(graphics);
        }
    }

    public void addNotify() {
        if (this.fJSSP != null) {
            this.fJSSP.causeExpose();
        }
        super.addNotify();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (this.fJSSP != null && (dimension = this.fJSSP.getMaxViewportSize()) != null) {
            if (n3 > (int)dimension.getWidth()) {
                n3 = (int)dimension.getWidth();
            }
            if (n4 > (int)dimension.getHeight()) {
                n4 = (int)dimension.getHeight();
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        Dimension dimension;
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (rectangle2.width < 0) {
            rectangle2.width = 0;
        }
        if (rectangle2.height < 0) {
            rectangle2.height = 0;
        }
        if (this.fJSSP != null && (dimension = this.fJSSP.getMaxViewportSize()) != null) {
            if (rectangle2.width > (int)dimension.getWidth()) {
                rectangle2.width = (int)dimension.getWidth();
            }
            if (rectangle2.height > (int)dimension.getHeight()) {
                rectangle2.height = (int)dimension.getHeight();
            }
        }
        super.setBounds(rectangle2);
    }

    @Override
    public boolean isComponentLightweight() {
        return false;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private static native void enterCriticalSection();

    private static native void exitCriticalSection();
}

