/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.SwingUtilities;

public class OffscreenWindowProvider {
    private static Container sTheWindow = null;
    private static boolean sInitialized = false;
    private static final String OFFSCREEN_WINDOW_NAME = "HG_Peer_OffScreenWindow";

    public static Container getWindow() {
        if (!sInitialized) {
            if (!GraphicsEnvironment.isHeadless()) {
                sTheWindow = new Window(null);
                sTheWindow.setLayout(null);
                sTheWindow.setName(OFFSCREEN_WINDOW_NAME);
            } else {
                sTheWindow = new Panel();
                sTheWindow.addNotify();
            }
            OffscreenWindowProvider.fixWindowDimensions();
            sTheWindow.setVisible(true);
            sTheWindow.addComponentListener(new WindowProviderComponentListener());
            sInitialized = true;
        }
        return sTheWindow;
    }

    public static boolean isInitialized() {
        return sInitialized;
    }

    public static void remove(Component component) {
        Container container = OffscreenWindowProvider.getWindow();
        container.remove(component);
        if (container.getComponentCount() < 1) {
            sInitialized = false;
            if (!GraphicsEnvironment.isHeadless()) {
                ((Window)container).dispose();
            } else {
                container.removeNotify();
            }
        }
    }

    private static void fixWindowDimensions() {
        sTheWindow.setSize(2, 2);
        sTheWindow.setLocation(Short.MIN_VALUE, Short.MIN_VALUE);
    }

    public static boolean isComponentInOffscreenWindow(Component component) {
        boolean bl = false;
        if (component != null) {
            Window window = null;
            window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            if (window != null) {
                bl = OFFSCREEN_WINDOW_NAME.equals(window.getName());
            }
        }
        return bl;
    }

    public static boolean isComponentReallyVisible(Component component) {
        if (component == null) {
            return false;
        }
        if (GraphicsEnvironment.isHeadless() || OffscreenWindowProvider.isComponentInOffscreenWindow(component)) {
            return false;
        }
        boolean bl = true;
        for (Component component2 = component; component2 != null && bl; component2 = component2.getParent()) {
            bl = component2.isVisible() && component2.isDisplayable();
        }
        return bl;
    }

    private static class WindowProviderComponentListener
    extends ComponentAdapter {
        private WindowProviderComponentListener() {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            OffscreenWindowProvider.fixWindowDimensions();
        }
    }
}

