/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.table;

import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.HeaderBorder;
import com.mathworks.widgets.spreadsheet.SpreadsheetColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MultilineTableHeaderRenderer
extends JList
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public MultilineTableHeaderRenderer() {
        this.setOpaque(true);
        LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (jTable != null) {
            this.setEnabled(jTable.isEnabled());
        }
        if (PlatformInfo.isMacintosh()) {
            MultilineTableHeaderRenderer.setMacHeaderUI(jTable, this);
        } else {
            this.setBorder((Border)new HeaderBorder((Color)SystemColor.controlShadow));
        }
        String string = object == null ? "" : object.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        this.setListData(vector);
        return this;
    }

    protected static void setMacHeaderUI(JTable jTable, JComponent jComponent) {
        if (!GraphicsEnvironment.isHeadless()) {
            SpreadsheetColor spreadsheetColor = new SpreadsheetColor(jTable);
            jComponent.setBackground(spreadsheetColor.getHeaderUnselectedBackground());
            jComponent.setForeground(spreadsheetColor.getHeaderUnselectedForeground());
            HeaderBorder headerBorder = new HeaderBorder((Color)SystemColor.controlShadow);
            jComponent.setBorder((Border)headerBorder);
        }
    }

    public void setHorizontalAlignment(int n) {
        ListCellRenderer listCellRenderer = this.getCellRenderer();
        ((JLabel)((Object)listCellRenderer)).setHorizontalAlignment(n);
        this.setCellRenderer(listCellRenderer);
    }
}

