/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.util.Log;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.fop.fonts.CustomFont;

public class FontCachingGraphics2D
extends Graphics2D {
    private HashMap<String, Font> fFontHash = new HashMap();
    private Container fContainer;
    private boolean fHaveCheckedForCMFonts = false;
    private boolean fHasComputerModernFonts = false;
    public static String[] COMPUTER_MODERN_FONT_PREFIXES = new String[]{"mwa", "mwb"};
    private Rectangle fClip;

    public FontCachingGraphics2D(Container container) {
        this(container, null);
    }

    private void checkForCMFonts() {
        if (this.fHaveCheckedForCMFonts) {
            return;
        }
        final FontCachingGraphics2D fontCachingGraphics2D = this;
        if (this.fContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            FontCachingGraphics2D.this.fContainer.printAll(fontCachingGraphics2D);
                        }
                    });
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            } else {
                this.fContainer.printAll(this);
            }
        }
        this.fHaveCheckedForCMFonts = true;
    }

    public FontCachingGraphics2D() {
        this(null, null);
    }

    private FontCachingGraphics2D(Container container, HashMap<String, Font> hashMap) {
        this.fContainer = container;
        this.fClip = this.fContainer != null ? this.fContainer.getBounds() : new Rectangle();
        if (hashMap != null) {
            this.fFontHash = hashMap;
        } else {
            this.fFontHash.clear();
        }
    }

    private void addFont(Font font) {
        if (font == null) {
            return;
        }
        String string = font.getName() + "_" + font.getFontName() + "_" + (font.isBold() ? 1 : 0);
        if (!this.fFontHash.containsKey(string = string.toLowerCase())) {
            this.fFontHash.put(string, font);
        }
    }

    public List<Font> getFontList() {
        this.checkForCMFonts();
        ArrayList<Font> arrayList = new ArrayList<Font>();
        for (Font font : this.fFontHash.values()) {
            arrayList.add(font);
        }
        return arrayList;
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            this.addFont(font);
        }
    }

    public boolean usesComputerModernFonts() {
        this.checkForCMFonts();
        for (String string : this.fFontHash.keySet()) {
            for (String string2 : COMPUTER_MODERN_FONT_PREFIXES) {
                if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean usesFont(Font font) {
        this.checkForCMFonts();
        String string = font.getName() + "_" + font.getFontName() + "_" + (font.isBold() ? 1 : 0);
        string = string.toLowerCase();
        return this.fFontHash.containsKey(string);
    }

    public boolean usesFont(CustomFont customFont) {
        boolean bl;
        this.checkForCMFonts();
        String string = customFont.getFontSubName();
        if (string == null) {
            string = "";
        }
        int n = (bl = string.equals("Bold")) ? 1 : 0;
        String string2 = customFont.getFontName().toLowerCase();
        for (String string3 : COMPUTER_MODERN_FONT_PREFIXES) {
            String string4 = string3 + "_" + string2 + "_" + string3 + "_" + string2 + "_" + n;
            if (!this.fFontHash.containsKey(string4 = string4.toLowerCase())) continue;
            return true;
        }
        String string5 = string2 + "_" + string2 + "_" + n;
        return this.fFontHash.containsKey(string5);
    }

    @Override
    public Graphics create() {
        return new FontCachingGraphics2D(this.fContainer, this.fFontHash);
    }

    @Override
    public Graphics create(int n, int n2, int n3, int n4) {
        FontCachingGraphics2D fontCachingGraphics2D = new FontCachingGraphics2D(this.fContainer, this.fFontHash);
        fontCachingGraphics2D.fClip = new Rectangle(n, n2, n3, n4);
        return fontCachingGraphics2D;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (this.fContainer != null) {
            return this.fContainer.getFontMetrics(font);
        }
        Container container = new Container();
        return container.getFontMetrics(font);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.fClip;
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.fClip = new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.fClip = new Rectangle(n, n2, n3, n4);
    }

    @Override
    public Shape getClip() {
        return new Shape(){

            @Override
            public Rectangle getBounds() {
                return FontCachingGraphics2D.this.fClip;
            }

            @Override
            public Rectangle2D getBounds2D() {
                return new Rectangle2D(){

                    @Override
                    public void setRect(double d, double d2, double d3, double d4) {
                        FontCachingGraphics2D.this.fClip = new Rectangle((int)d, (int)d2, (int)d3, (int)d4);
                    }

                    @Override
                    public int outcode(double d, double d2) {
                        return 0;
                    }

                    @Override
                    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
                        return null;
                    }

                    @Override
                    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
                        return null;
                    }

                    @Override
                    public double getX() {
                        return ((FontCachingGraphics2D)FontCachingGraphics2D.this).fClip.x;
                    }

                    @Override
                    public double getY() {
                        return ((FontCachingGraphics2D)FontCachingGraphics2D.this).fClip.y;
                    }

                    @Override
                    public double getWidth() {
                        return ((FontCachingGraphics2D)FontCachingGraphics2D.this).fClip.width;
                    }

                    @Override
                    public double getHeight() {
                        return ((FontCachingGraphics2D)FontCachingGraphics2D.this).fClip.height;
                    }

                    @Override
                    public boolean isEmpty() {
                        return false;
                    }
                };
            }

            @Override
            public boolean contains(double d, double d2) {
                return true;
            }

            @Override
            public boolean contains(Point2D point2D) {
                return true;
            }

            @Override
            public boolean intersects(double d, double d2, double d3, double d4) {
                return true;
            }

            @Override
            public boolean intersects(Rectangle2D rectangle2D) {
                return true;
            }

            @Override
            public boolean contains(double d, double d2, double d3, double d4) {
                return true;
            }

            @Override
            public boolean contains(Rectangle2D rectangle2D) {
                return true;
            }

            @Override
            public PathIterator getPathIterator(AffineTransform affineTransform) {
                return null;
            }

            @Override
            public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
                return null;
            }
        };
    }

    @Override
    public void setClip(Shape shape) {
        if (shape != null) {
            this.fClip = shape.getBounds();
        }
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    public void draw(Shape shape) {
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawString(String string, int n, int n2) {
    }

    @Override
    public void drawString(String string, float f, float f2) {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
    }

    @Override
    public void fill(Shape shape) {
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return true;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public void setComposite(Composite composite) {
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public void setStroke(Stroke stroke) {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public void translate(int n, int n2) {
    }

    @Override
    public Color getColor() {
        return Color.WHITE;
    }

    @Override
    public void setColor(Color color) {
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public Font getFont() {
        Font font = new Font("Monospaced", 0, 12);
        if (this.fFontHash.size() > 0) {
            font = this.fFontHash.get(this.fFontHash.keySet().toArray()[this.fFontHash.size() - 1]);
        }
        return font;
    }

    @Override
    public void translate(double d, double d2) {
    }

    @Override
    public void rotate(double d) {
    }

    @Override
    public void rotate(double d, double d2, double d3) {
    }

    @Override
    public void scale(double d, double d2) {
    }

    @Override
    public void shear(double d, double d2) {
    }

    @Override
    public void transform(AffineTransform affineTransform) {
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
    }

    @Override
    public AffineTransform getTransform() {
        return null;
    }

    @Override
    public Paint getPaint() {
        return null;
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public Color getBackground() {
        return Color.WHITE;
    }

    @Override
    public Stroke getStroke() {
        return new Stroke(){

            @Override
            public Shape createStrokedShape(Shape shape) {
                return new Rectangle();
            }
        };
    }

    @Override
    public void clip(Shape shape) {
        if (shape != null) {
            this.fClip = shape.getBounds();
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(), true, false);
    }
}

