/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ImageUtils {
    public static BufferedImage renderImage(Image image, ImageObserver imageObserver) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            bufferedImage = new BufferedImage(image.getWidth(imageObserver), image.getHeight(imageObserver), 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, imageObserver);
            graphics.dispose();
        }
        return bufferedImage;
    }

    public static boolean drawImageTransform(Graphics2D graphics2D, Image image, int n, int n2, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        return graphics2D.drawImage(image, affineTransform, imageObserver);
    }

    public static boolean drawImageTransform(Graphics2D graphics2D, Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        double d = (double)n3 / (double)image.getWidth(imageObserver);
        double d2 = (double)n4 / (double)image.getHeight(imageObserver);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d2);
        affineTransform.translate(n, n2);
        return graphics2D.drawImage(image, affineTransform, imageObserver);
    }

    public static boolean drawImageTransform(Graphics2D graphics2D, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        ImageUtils.fillGraphicsRect(graphics2D, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color);
        return ImageUtils.drawImageTransform(graphics2D, image, n, n2, imageObserver);
    }

    public static boolean drawImageTransform(Graphics2D graphics2D, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        ImageUtils.fillGraphicsRect(graphics2D, n, n2, n3, n4, color);
        return ImageUtils.drawImageTransform(graphics2D, image, n, n2, n3, n4, imageObserver);
    }

    public static boolean drawImageTransform(Graphics2D graphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = ((BufferedImage)image).getSubimage(n5, n6, n7 - n5, n8 - n6);
        } else {
            int n9 = n7 - n5;
            int n10 = n8 - n6;
            bufferedImage = new BufferedImage(n9, n10, 2);
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            graphics.drawImage(image, 0, 0, n9, n10, n5, n6, n7, n8, imageObserver);
            graphics.dispose();
        }
        return ImageUtils.drawImageTransform(graphics2D, bufferedImage, n, n2, n3 - n, n4 - n2, imageObserver);
    }

    public static boolean drawImageTransform(Graphics2D graphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        ImageUtils.fillGraphicsRect(graphics2D, n, n2, n3 - n, n4 - n2, color);
        return ImageUtils.drawImageTransform(graphics2D, image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    private static void fillGraphicsRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(paint);
    }
}

