/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print.metafile;

import java.awt.Font;
import java.lang.constant.Constable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;

public class SunFontProxy {
    private static SunFontProxy sInstance = null;
    private boolean fClassesLoaded = false;
    private Class fFontUtilsClass = null;
    private Class fFont2DClass = null;
    private Class fCompositeFontClass = null;
    private Class fPhysicalFontClass = null;
    private Class fCharMapperClass = null;
    private MethodHandle fGetFont2DMethod = null;
    private MethodHandle fGetMapperMethod = null;
    private MethodHandle fCharsToGlyphsMethod = null;
    private MethodHandle fGetSlotFontMethod = null;
    private MethodHandle fGetFamilyNameMethod = null;
    private MethodHandle fGetStyleMethod = null;
    private int fSlotMask = 0;

    private SunFontProxy() {
        this.init();
    }

    private void init() {
        if (!this.fClassesLoaded) {
            Constable constable;
            boolean bl = true;
            try {
                this.fFontUtilsClass = Class.forName("sun.font.FontUtilities");
                this.fFont2DClass = Class.forName("sun.font.Font2D");
                this.fCompositeFontClass = Class.forName("sun.font.CompositeFont");
                this.fPhysicalFontClass = Class.forName("sun.font.PhysicalFont");
                this.fCharMapperClass = Class.forName("sun.font.CharToGlyphMapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
            }
            if (bl) {
                try {
                    constable = MethodType.methodType(this.fFont2DClass, Font.class);
                    this.fGetFont2DMethod = MethodHandles.lookup().findStatic(this.fFontUtilsClass, "getFont2D", (MethodType)constable);
                    this.fGetMapperMethod = this.createVirtualMethodHandle(this.fCompositeFontClass, "getMapper", this.fCharMapperClass, new Class[0]);
                    this.fCharsToGlyphsMethod = this.createVirtualMethodHandle(this.fCharMapperClass, "charsToGlyphs", Void.TYPE, Integer.TYPE, char[].class, int[].class);
                    this.fGetSlotFontMethod = this.createVirtualMethodHandle(this.fCompositeFontClass, "getSlotFont", this.fPhysicalFontClass, Integer.TYPE);
                    this.fGetFamilyNameMethod = this.createVirtualMethodHandle(this.fFont2DClass, "getFamilyName", String.class, Locale.class);
                    this.fGetStyleMethod = this.createVirtualMethodHandle(this.fFont2DClass, "getStyle", Integer.TYPE, new Class[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                    bl = false;
                }
            }
            if (bl) {
                try {
                    constable = Class.forName("sun.font.CompositeGlyphMapper");
                    MethodHandle methodHandle = MethodHandles.lookup().findStaticGetter((Class<?>)constable, "SLOTMASK", Integer.TYPE);
                    this.fSlotMask = methodHandle.invokeExact();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = false;
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    bl = false;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
            }
            this.fClassesLoaded = bl;
        }
    }

    private MethodHandle createVirtualMethodHandle(Class clazz, String string, Class clazz2, Class ... classArray) throws NoSuchMethodException, IllegalAccessException {
        MethodType methodType = MethodType.methodType(clazz2, classArray);
        return MethodHandles.lookup().findVirtual(clazz, string, methodType);
    }

    public static SunFontProxy getInstance() {
        if (sInstance == null) {
            sInstance = new SunFontProxy();
        }
        return sInstance;
    }

    public boolean isValid() {
        return this.fClassesLoaded;
    }

    public Object getFont2D(Font font) {
        if (this.isValid()) {
            try {
                return this.fGetFont2DMethod.invoke(font);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isCompositeFont(Object object) {
        if (this.isValid()) {
            return this.fCompositeFontClass.isAssignableFrom(object.getClass());
        }
        return false;
    }

    public void charsToGlyphs(Object object, int n, char[] cArray, int[] nArray) {
        if (this.isValid()) {
            try {
                Object object2 = this.fGetMapperMethod.invoke(object);
                this.fCharsToGlyphsMethod.invoke(object2, n, cArray, nArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Object getSlotFont(Object object, int n) {
        if (this.isValid()) {
            try {
                return this.fGetSlotFontMethod.invoke(object, n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public String getFamilyName(Object object) {
        if (this.isValid()) {
            try {
                return this.fGetFamilyNameMethod.invoke(object, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public int getStyle(Object object) {
        if (this.isValid()) {
            try {
                return this.fGetStyleMethod.invoke(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getSlot(int n) {
        if (this.isValid()) {
            return (n & this.fSlotMask) >> 24;
        }
        return 0;
    }
}

