/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.hg.types.HGCallback;
import com.mathworks.hg.types.HGTypeEditorIcon;
import com.mathworks.hg.util.HGHelpers;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwswing.MJLabel;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class HGCallbackEditor
extends MWPropertyEditorSupport {
    private MJLabel fRenderer;
    private Object fParentFigure;
    private Object[] fEditObject;
    private Object fPropertyName;
    private boolean fIsDesignTime;
    private volatile String fTempString = null;
    private static Image sIcon = null;

    public boolean supportsInPlaceEditing() {
        return true;
    }

    public Image getIcon() {
        if (sIcon == null) {
            sIcon = HGTypeEditorIcon.CALLBACK.getIcon().getImage();
        }
        return sIcon;
    }

    public boolean hasCustomDialog() {
        return this.fIsDesignTime;
    }

    public void invokeDialog() {
        this.launchCallbackEditor();
    }

    public void updateComponentState() {
        HGCallback hGCallback = (HGCallback)this.getValue();
        if (hGCallback != null && this.fRenderer != null) {
            this.fRenderer.setText(this.getAsText(false));
            this.fRenderer.setEnabled(this.supportsCustomEditor() && (this.getCustomEditor() != null || this.hasCustomDialog()));
            if (this.fRenderer != null) {
                this.fRenderer.repaint();
            }
        }
    }

    public JComponent getInspectorRenderer() {
        if (this.fRenderer == null) {
            this.fRenderer = new HGCallbackEditorRenderer(this.getAsText(false));
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    HGCallbackEditor.this.launchCallbackEditor();
                }
            };
            this.fRenderer.addMouseListener((MouseListener)mouseInputAdapter);
            this.updateComponentState();
        }
        return this.fRenderer;
    }

    public void launchCallbackEditor() {
        Matlab matlab = new Matlab();
        try {
            if (this.fIsDesignTime) {
                Object[] objectArray = new Object[]{"editCallback", this.fParentFigure, this.fEditObject, this.fPropertyName};
                matlab.feval("guidefunc", objectArray, 1, (CompletionObserver)null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEditObject(Object[] objectArray) {
        this.fIsDesignTime = false;
        this.fEditObject = objectArray;
        Object object = null;
        if (objectArray != null && objectArray.length > 0) {
            object = objectArray[0];
        }
        if (object != null && object instanceof UDDObject) {
            String string;
            UDDObject uDDObject = (UDDObject)object;
            String string2 = string = HGHelpers.isHGUsingMATLABClasses() ? "matlab.ui.Figure" : "figure";
            while (uDDObject.isValid() && !uDDObject.getClassName().equals(string) && uDDObject.up() != null && uDDObject.up() instanceof UDDObject) {
                uDDObject = (UDDObject)uDDObject.up();
            }
            if (uDDObject.isValid()) {
                if (uDDObject.getClassName().equals(string)) {
                    this.fParentFigure = uDDObject;
                }
                if (this.fParentFigure != null) {
                    this.fIsDesignTime = uDDObject.findProperty("GUIDEFigure") != null;
                }
            }
        }
    }

    public boolean hasAttachedData() {
        return true;
    }

    public String getDataKey() {
        return "BeanUtils.SortKey";
    }

    public void setData(Object object) {
        this.fPropertyName = object;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return null;
    }

    public String getAsText() {
        return this.getAsText(true);
    }

    String getAsText(boolean bl) {
        if (this.fTempString != null) {
            return this.fTempString;
        }
        String string = "";
        HGCallback hGCallback = (HGCallback)this.getValue();
        if (hGCallback != null) {
            string = hGCallback.getCallbackString(bl);
        }
        return string;
    }

    public void setAsText(final String string) {
        this.fTempString = string;
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                HGCallbackEditor.this.setAsText_MatlabThread(HGCallback.presetCallbackString(string));
                HGCallbackEditor.this.fTempString = null;
            }
        });
    }

    private void setAsText_MatlabThread(String string) {
        MLArrayRef mLArrayRef = null;
        Object[] objectArray = new Object[1];
        if (string != null && string.length() >= 0) {
            try {
                objectArray[0] = "system_dependent(45," + string + ")";
                mLArrayRef = (MLArrayRef)Matlab.mtFeval((String)"eval", (Object[])objectArray, (int)1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mLArrayRef != null) {
                this.setValue(new HGCallback(string, mLArrayRef));
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    static class HGCallbackEditorRenderer
    extends MJLabel {
        HGCallbackEditorRenderer(String string) {
            super(string.replaceAll("^\\s*'|'\\s*$", ""));
        }

        public void setText(String string, boolean bl) {
            super.setText(string.replaceAll("^\\s*'|'\\s*$", ""), bl);
        }
    }
}

