/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.util.PlatformInfo;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class ExportClipboardHelper
implements Transferable {
    public static final String EMF_FORMAT = "emf";
    public static final DataFlavor EMF_FLAVOR = new DataFlavor("image/emf", "Enhanced Metafile");
    public static final String PDF_FORMAT = "pdf";
    public static final DataFlavor PDF_FLAVOR = new DataFlavor("application/pdf", "Portable Document Format");
    public static final String IMAGE_FORMAT = "image";
    public static final DataFlavor IMAGE_FLAVOR = DataFlavor.imageFlavor;
    private static HashMap sFlavorMap = null;
    private DataFlavor[] fSupportedFlavors = null;
    private ByteArrayOutputStream fStreamData;
    private Image fImageData;

    static void addToFlavorMap(String string, DataFlavor dataFlavor) {
        if (sFlavorMap == null) {
            sFlavorMap = new HashMap();
        }
        DataFlavor[] dataFlavorArray = new DataFlavor[]{dataFlavor};
        sFlavorMap.put(string, dataFlavorArray);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(EMF_FLAVOR) || dataFlavor.equals(PDF_FLAVOR)) {
            return new ByteArrayInputStream(this.fStreamData.toByteArray());
        }
        if (dataFlavor.equals(IMAGE_FLAVOR)) {
            return this.fImageData;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.fSupportedFlavors;
    }

    private void setTransferDataFlavors(DataFlavor[] dataFlavorArray) {
        this.fSupportedFlavors = dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : this.getTransferDataFlavors()) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public void copyToClipboard() throws IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(this, null);
        if (PlatformInfo.isWindows() && this.fSupportedFlavors[0] == EMF_FLAVOR && this.fStreamData.size() > 40000000 && !NativeClipboardChecker.isMetafileOnClipboard()) {
            throw new IOException("Clipboard copy failed.");
        }
    }

    public ExportClipboardHelper(String string, ByteArrayOutputStream byteArrayOutputStream) throws UnsupportedFlavorException {
        this.fStreamData = byteArrayOutputStream;
        if (sFlavorMap.get(string) == null) {
            throw new UnsupportedFlavorException(null);
        }
        this.setTransferDataFlavors((DataFlavor[])sFlavorMap.get(string));
    }

    public ExportClipboardHelper(String string, Image image) throws UnsupportedFlavorException {
        this.fImageData = image;
        if (sFlavorMap.get(string) == null) {
            throw new UnsupportedFlavorException(null);
        }
        this.setTransferDataFlavors((DataFlavor[])sFlavorMap.get(string));
    }

    static {
        SystemFlavorMap systemFlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        systemFlavorMap.addUnencodedNativeForFlavor(EMF_FLAVOR, "ENHMETAFILE");
        systemFlavorMap.addUnencodedNativeForFlavor(PDF_FLAVOR, "Portable Document Format");
        if (PlatformInfo.isMacintosh() && PlatformInfo.getVersion() > 7) {
            List<String> list = systemFlavorMap.getNativesForFlavor(PDF_FLAVOR);
            list.add("PDF");
            String[] stringArray = list.toArray(new String[list.size()]);
            systemFlavorMap.setNativesForFlavor(PDF_FLAVOR, stringArray);
            DataFlavor[] dataFlavorArray = new DataFlavor[]{PDF_FLAVOR};
            systemFlavorMap.setFlavorsForNative(PDF_FORMAT, dataFlavorArray);
        }
        ExportClipboardHelper.addToFlavorMap(EMF_FORMAT, EMF_FLAVOR);
        ExportClipboardHelper.addToFlavorMap(PDF_FORMAT, PDF_FLAVOR);
        ExportClipboardHelper.addToFlavorMap(IMAGE_FORMAT, IMAGE_FLAVOR);
    }

    private static class NativeClipboardChecker {
        private static boolean sIsNativeLibraryLoaded = false;

        private NativeClipboardChecker() {
        }

        public static boolean isMetafileOnClipboard() {
            if (sIsNativeLibraryLoaded) {
                return NativeClipboardChecker.doIsMetafileOnClipboard();
            }
            return false;
        }

        private static native boolean doIsMetafileOnClipboard();

        static {
            try {
                System.loadLibrary("nativehg");
                sIsNativeLibraryLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }
}

