/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.mapreduce;

import com.mathworks.toolbox.parallel.mapreduce.Endpoint;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueMessage;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueSocket;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public final class KeyValuesProxySource
implements Closeable {
    private final KeyValueSocket fKeyValueSocket = new KeyValueSocket();
    private ByteBuffer fCurrentKey = null;
    private ByteBuffer fCurrentValue = null;
    private KeyValueMessage.Type fLastMessageType;
    private boolean fFinished = false;

    public KeyValuesProxySource(Endpoint endpoint) throws IOException, InterruptedException {
        this.fKeyValueSocket.connect(endpoint);
    }

    public boolean nextKeyOrValue(long l, TimeUnit timeUnit) throws IOException {
        if (this.fFinished) {
            return false;
        }
        KeyValueMessage keyValueMessage = this.fKeyValueSocket.recv(l, timeUnit);
        if (keyValueMessage == null) {
            return false;
        }
        this.fLastMessageType = keyValueMessage.getType();
        switch (keyValueMessage.getType()) {
            case CLOSE: {
                this.fFinished = true;
            }
            case KEY: {
                this.fCurrentKey = keyValueMessage.getContent();
                break;
            }
            case VALUE: {
                this.fCurrentValue = keyValueMessage.getContent();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.fLastMessageType = keyValueMessage.getType();
        return true;
    }

    public boolean isFinished() {
        return this.fFinished;
    }

    public boolean isLastMessageAKey() {
        return this.fLastMessageType == KeyValueMessage.Type.KEY;
    }

    public boolean isLastMessageAValue() {
        return this.fLastMessageType == KeyValueMessage.Type.VALUE;
    }

    public ByteBuffer getCurrentKey() {
        return this.fCurrentKey;
    }

    public ByteBuffer getCurrentValue() {
        return this.fCurrentValue;
    }

    public byte[] getCurrentKeyAsByteArray() {
        return this.fCurrentKey != null ? KeyValuesProxySource.convertToByteArray(this.fCurrentKey) : null;
    }

    public byte[] getCurrentValueAsByteArray() {
        return this.fCurrentKey != null ? KeyValuesProxySource.convertToByteArray(this.fCurrentValue) : null;
    }

    @Override
    public void close() throws IOException {
        this.fCurrentKey = null;
        this.fCurrentValue = null;
        this.fKeyValueSocket.close();
    }

    private static byte[] convertToByteArray(ByteBuffer byteBuffer) {
        byteBuffer = byteBuffer.duplicate();
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }
}

