/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.LuceneVersion;
import java.io.Reader;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.lucene.util.Version;

public class MWAnalyzer {
    private final Analyzer fAnalyzer;
    private static final CharArraySet STOP_WORD_CHAR_ARRAY_SET = new CharArraySet(LuceneVersion.CURRENT_VERSION, Arrays.asList(""), true);

    public MWAnalyzer(SearchLanguage language) {
        switch (language) {
            case JAPANESE: 
            case SIMPLIFIED_CHINESE: 
            case KOREAN: {
                this.fAnalyzer = new CJKAnalyzer(LuceneVersion.CURRENT_VERSION, STOP_WORD_CHAR_ARRAY_SET);
                break;
            }
            default: {
                this.fAnalyzer = new HelpAnalyzer();
            }
        }
    }

    public Analyzer getIndexAnalyzer() {
        return this.fAnalyzer;
    }

    public Analyzer getSearchAnalyzer() {
        return this.fAnalyzer;
    }

    private static class LetterDigitTokenizer
    extends CharTokenizer {
        private LetterDigitTokenizer(Version version, Reader reader) {
            super(version, reader);
        }

        protected boolean isTokenChar(int c) {
            return Character.isLetter(c) || Character.isDigit(c) || c == 95;
        }
    }

    private static class HelpAnalyzer
    extends Analyzer {
        private HelpAnalyzer() {
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            LetterDigitTokenizer source = new LetterDigitTokenizer(LuceneVersion.CURRENT_VERSION, reader);
            LowerCaseFilter filter = new LowerCaseFilter(LuceneVersion.CURRENT_VERSION, (TokenStream)source);
            return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
        }
    }
}

