/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.svggen.AbstractImageHandlerEncoder;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class ImageHandlerPNGEncoder
extends AbstractImageHandlerEncoder {
    public ImageHandlerPNGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        super(string, string2);
    }

    @Override
    public final String getSuffix() {
        return ".png";
    }

    @Override
    public final String getPrefix() {
        return "pngImage";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeImage(BufferedImage bufferedImage, File file) throws SVGGraphics2DIOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
            imageWriter.writeImage((RenderedImage)bufferedImage, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("could not write image File " + file.getName());
        }
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }
}

