/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.SystemBrowserStrategy;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

class DefaultSystemBrowserStrategy
implements SystemBrowserStrategy {
    DefaultSystemBrowserStrategy() {
    }

    @Override
    public void openSystemBrowser(Url url, HtmlDataListener<Boolean> htmlDataListener) {
        URI uRI = (URI)new SystemBrowserHandler().transformUrl(url);
        if (uRI != null) {
            try {
                Desktop.getDesktop().browse(uRI);
                htmlDataListener.dataRetrieved(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        htmlDataListener.dataRetrieved(false);
    }

    private static class SystemBrowserHandler
    extends UrlTransformer<URI> {
        private SystemBrowserHandler() {
        }

        @Override
        protected URI transformWebUrl(WebUrl webUrl) {
            try {
                return webUrl.toURL().toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        @Override
        protected URI transformFileUrl(FileUrl fileUrl) {
            return fileUrl.getFile().toURI();
        }

        @Override
        protected URI transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return null;
        }
    }
}

