/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EncodingUtils {
    private static final char TO_UPPER = ' ';
    private static final Pattern QUERYSTRING_ENCODE_PATTERN = Pattern.compile("[^&=]+");

    public static String encodeUrl(String string) {
        try {
            return EncodingUtils.encodeUrl(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false) : "We should be able to encode URLs using UTF-8";
            return string;
        }
    }

    public static String encodeUrl(String string, String string2) throws UnsupportedEncodingException {
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            int n = string.indexOf(63);
            if (n > -1) {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                return EncodingUtils.encodeBaseUrl(string3, string2) + '?' + EncodingUtils.encodeQueryString(string4, string2);
            }
            return EncodingUtils.encodeBaseUrl(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (RuntimeException runtimeException) {
            throw new UnsupportedEncodingException();
        }
    }

    public static String decodeUrl(String string) {
        try {
            return EncodingUtils.decodeUrl(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false) : "We should be able to decode URLs using UTF-8";
            return string;
        }
    }

    public static String decodeUrl(String string, String string2) throws UnsupportedEncodingException {
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            int n = string.indexOf(63);
            if (n > -1) {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                return EncodingUtils.decodeBaseUrl(string3, string2) + '?' + EncodingUtils.decodeQueryString(string4, string2);
            }
            return EncodingUtils.decodeBaseUrl(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (RuntimeException runtimeException) {
            throw new UnsupportedEncodingException();
        }
    }

    static String encodeBaseUrl(String string) {
        return EncodingUtils.encodeBaseUrl(string, false);
    }

    static String encodeBaseUrl(String string, boolean bl) {
        try {
            return EncodingUtils.encodeBaseUrl(string, "UTF-8", bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false) : "We should be able to encode URLs using UTF-8";
            return string;
        }
    }

    static String encodeBaseUrl(String string, String string2) throws UnsupportedEncodingException {
        return EncodingUtils.encodeBaseUrl(string, string2, false);
    }

    static String encodeBaseUrl(String string, String string2, boolean bl) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (EncodingUtils.requiresEncoding(c, bl)) {
                stringBuilder.append(EncodingUtils.encodeCharacter(c, string2));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean requiresEncoding(char c, boolean bl) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return false;
        }
        switch (c) {
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case '_': 
            case '~': {
                return false;
            }
            case '/': {
                return bl;
            }
        }
        return true;
    }

    private static String encodeCharacter(char c, String string) throws UnsupportedEncodingException {
        byte[] byArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray = String.valueOf(c).getBytes(string)) {
            char c2;
            stringBuilder.append('%');
            char c3 = Character.forDigit(by >> 4 & 0xF, 16);
            if (Character.isLetter(c3)) {
                c3 = (char)(c3 - 32);
            }
            if (Character.isLetter(c2 = Character.forDigit(by & 0xF, 16))) {
                c2 = (char)(c2 - 32);
            }
            stringBuilder.append(c3).append(c2);
        }
        return stringBuilder.toString();
    }

    private static String encodeString(String string, String string2) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder.append(EncodingUtils.encodeCharacter(c, string2));
        }
        return stringBuilder.toString();
    }

    static String decodeBaseUrl(String string) {
        try {
            return EncodingUtils.decodeBaseUrl(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false) : "We should be able to decode URLs using UTF-8";
            return string;
        }
    }

    static String decodeBaseUrl(String string, String string2) throws UnsupportedEncodingException {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '%') {
                byte[] byArray = new byte[(n - n2) / 3];
                int n3 = 0;
                do {
                    byArray[n3++] = (byte)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                    if ((n2 += 3) >= n) continue;
                    c = string.charAt(n2);
                } while (c == '%' && n2 + 2 < string.length());
                stringBuilder.append(new String(byArray, 0, n3, string2));
                continue;
            }
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }

    static String encodeQueryString(String string, String string2) {
        try {
            Matcher matcher = QUERYSTRING_ENCODE_PATTERN.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, URLEncoder.encode(matcher.group(), string2));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    static String decodeQueryString(String string, String string2) {
        try {
            Matcher matcher = QUERYSTRING_ENCODE_PATTERN.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, URLDecoder.decode(matcher.group(), string2));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static boolean needsEncoding(String string) {
        return EncodingUtils.checkUrlForEncoding(string) == EncodingStatus.NEEDS_ENCODING;
    }

    public static boolean needsDecoding(String string) {
        return EncodingUtils.checkUrlForEncoding(string) == EncodingStatus.NEEDS_DECODING;
    }

    private static EncodingStatus checkUrlForEncoding(String string) {
        if (string == null || string.length() == 0) {
            return EncodingStatus.OK;
        }
        int n = string.indexOf(63);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            EncodingStatus encodingStatus = EncodingUtils.checkUrlPartForEncoding(string2, false);
            if (encodingStatus == EncodingStatus.NEEDS_ENCODING) {
                return encodingStatus;
            }
            EncodingStatus encodingStatus2 = EncodingUtils.checkQueryStringForEncoding(string3);
            if (encodingStatus2 == EncodingStatus.NEEDS_ENCODING) {
                return encodingStatus2;
            }
            if (encodingStatus == EncodingStatus.NEEDS_DECODING || encodingStatus2 == EncodingStatus.NEEDS_DECODING) {
                return EncodingStatus.NEEDS_DECODING;
            }
            return EncodingStatus.OK;
        }
        return EncodingUtils.checkUrlPartForEncoding(string, false);
    }

    private static EncodingStatus checkUrlPartForEncoding(String string, boolean bl) {
        EncodingStatus encodingStatus = EncodingStatus.OK;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (EncodingUtils.isEscapedCharacter(string, i)) {
                    encodingStatus = EncodingStatus.NEEDS_DECODING;
                    i += 2;
                    continue;
                }
                return EncodingStatus.NEEDS_ENCODING;
            }
            if (bl && c == '+') {
                encodingStatus = EncodingStatus.NEEDS_DECODING;
                continue;
            }
            if (c < '\u0080' && c != ' ') continue;
            return EncodingStatus.NEEDS_ENCODING;
        }
        return encodingStatus;
    }

    private static EncodingStatus checkQueryStringForEncoding(String string) {
        EncodingStatus encodingStatus = EncodingStatus.OK;
        Matcher matcher = QUERYSTRING_ENCODE_PATTERN.matcher(string);
        while (matcher.find()) {
            switch (EncodingUtils.checkUrlPartForEncoding(matcher.group(), true)) {
                case NEEDS_ENCODING: {
                    return EncodingStatus.NEEDS_ENCODING;
                }
                case NEEDS_DECODING: {
                    encodingStatus = EncodingStatus.NEEDS_DECODING;
                    break;
                }
            }
        }
        return encodingStatus;
    }

    private static boolean isEscapedCharacter(String string, int n) {
        if (string.length() < n + 3) {
            return false;
        }
        String string2 = string.substring(n + 1, n + 3);
        return string2.matches("[0-9A-Fa-f]{2}");
    }

    public static String changeUrlEncoding(String string, String string2, String string3) {
        Pattern pattern = Pattern.compile("(%[0-9A-Fa-f]{2})+");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (matcher.find()) {
                String string4 = EncodingUtils.decodeBaseUrl(matcher.group(), string2);
                String string5 = EncodingUtils.encodeString(string4, string3);
                matcher.appendReplacement(stringBuffer, string5);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static enum EncodingStatus {
        OK,
        NEEDS_ENCODING,
        NEEDS_DECODING;

    }
}

