/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CloneableUrl;
import com.mathworks.html.EncodingUtils;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlPartParser;
import com.mathworks.html.UrlVisitor;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FileUrl
extends CloneableUrl<FileUrl> {
    private final File fFile;
    private final String fBaseUrl;
    private static FileFilter sExistenceRules = new DefaultFileExistenceRules();

    public FileUrl(File file) {
        this(file, Collections.emptyMap(), null);
    }

    public FileUrl(File file, Map<String, List<String>> map, String string) {
        super(map, string);
        this.fFile = file;
        this.fBaseUrl = FileUrl.createBaseUrl(file);
    }

    public FileUrl(URL uRL) {
        this(FileUrl.getFileFromURL(uRL), UrlPartParser.parseParameters(uRL.getQuery()), uRL.getRef());
    }

    private static File getFileFromURL(URL uRL) {
        String string = uRL.getProtocol();
        if (string.equals("file")) {
            try {
                return new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return new File(uRL.getFile());
            }
        }
        throw new IllegalArgumentException("URL " + uRL + " does not represent a file.");
    }

    public File getFile() {
        return this.fFile;
    }

    @Override
    public Url.UrlType getType() {
        return Url.UrlType.FILE;
    }

    @Override
    public String getProtocol() {
        return "file";
    }

    @Override
    public String getBaseUrl() {
        return this.fBaseUrl;
    }

    private static String createBaseUrl(File file) {
        String string = file.getAbsolutePath().replaceAll("\\\\", "/");
        string = EncodingUtils.encodeBaseUrl(string);
        string = string.replaceFirst("^/(?!/)", "");
        return "file:///" + string;
    }

    @Override
    public void accept(UrlVisitor urlVisitor) {
        urlVisitor.visitFileUrl(this);
    }

    @Override
    protected CloneableUrl<FileUrl> append(String ... stringArray) {
        if (stringArray.length == 0) {
            return this;
        }
        File file = this.getFile();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            file = new File(file, stringArray[i]);
        }
        String string = stringArray[stringArray.length - 1];
        File file2 = new File(file, string);
        if (FileUrl.fileExists(file2)) {
            return new FileUrl(file2, this.getParameters(), this.getTarget());
        }
        try {
            return (CloneableUrl)new FileUrlParser(file).parseUrlParts(string);
        }
        catch (MalformedURLException malformedURLException) {
            return this;
        }
    }

    @Override
    protected FileUrl createModifiedCopy(Map<String, List<String>> map, String string) {
        return new FileUrl(this.fFile, map, string);
    }

    @Override
    public UrlBuilder<FileUrl> toUrlBuilder() {
        return new UrlBuilder<FileUrl>(this);
    }

    @Override
    protected Object[] getBaseUrlComparisonItems() {
        return new Object[]{this.fFile};
    }

    private static boolean fileExists(File file) {
        return sExistenceRules.accept(file);
    }

    private static void setFileExistenceRules(FileFilter fileFilter) {
        sExistenceRules = fileFilter == null ? new DefaultFileExistenceRules() : fileFilter;
    }

    private static class DefaultFileExistenceRules
    implements FileFilter {
        private DefaultFileExistenceRules() {
        }

        @Override
        public boolean accept(File file) {
            return file.exists();
        }
    }

    private static class FileUrlParser
    extends UrlPartParser<FileUrl> {
        private final File iDir;

        private FileUrlParser(File file) {
            this.iDir = file;
        }

        @Override
        protected FileUrl buildUrl(String string, Map<String, List<String>> map, String string2) {
            File file = new File(this.iDir, string);
            return new FileUrl(file, map, string2);
        }
    }
}

