/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.UrlParser;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class UrlPartParser<T> {
    private static final Pattern PARAM_AND_TARGET_PATTERN = Pattern.compile("[?#].*");
    private final Pattern fParamAndTargetPattern;

    protected UrlPartParser() {
        this(PARAM_AND_TARGET_PATTERN);
    }

    protected UrlPartParser(Pattern pattern) {
        this.fParamAndTargetPattern = pattern;
    }

    T parseUrlParts(String string) throws MalformedURLException {
        Matcher matcher = this.fParamAndTargetPattern.matcher(string);
        if (matcher.find()) {
            String string2 = string.substring(0, matcher.start());
            String string3 = matcher.group();
            return this.buildUrl(string2, string3);
        }
        return this.buildUrl(string, Collections.emptyMap(), null);
    }

    private T buildUrl(String string, String string2) throws MalformedURLException {
        Map<String, List<String>> map = Collections.emptyMap();
        String string3 = null;
        switch (string2.charAt(0)) {
            case '#': {
                string3 = string2.substring(1);
                break;
            }
            case '?': {
                String[] stringArray = string2.substring(1).split("#");
                map = UrlPartParser.parseParameters(stringArray[0]);
                string3 = stringArray.length > 1 ? stringArray[1] : null;
            }
        }
        return this.buildUrl(string, map, string3);
    }

    static Map<String, List<String>> parseParameters(String string) {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("[&;]")) {
                String[] stringArray2 = string2.split("=");
                String string3 = UrlPartParser.decodeParameterString(stringArray2[0]);
                if (stringArray2.length > 1) {
                    UrlParser.addParameter(linkedHashMap, string3, UrlPartParser.decodeParameterString(stringArray2[1]));
                    continue;
                }
                UrlParser.addParameter(linkedHashMap, string3, new String[0]);
            }
        }
        return linkedHashMap;
    }

    private static String decodeParameterString(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false) : "UTF-8 should be supported as a URL encoding character set.";
            return string;
        }
    }

    protected abstract T buildUrl(String var1, Map<String, List<String>> var2, String var3) throws MalformedURLException;
}

