/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.jxbrowser.FocusTracker;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

class JxBrowserFocusManager {
    private final JxBrowserSwingComponent fBrowserComponent;
    private final JxBrowserFocusListener fFocusListener;
    private final FocusTracker fFocusTracker;

    JxBrowserFocusManager(JxBrowserSwingComponent jxBrowserSwingComponent) {
        this.fBrowserComponent = jxBrowserSwingComponent;
        this.fFocusListener = new JxBrowserFocusListener();
        this.fFocusTracker = new FocusTracker(jxBrowserSwingComponent);
    }

    void install() {
        this.fBrowserComponent.addFocusListener(this.fFocusListener);
        this.fFocusTracker.install();
    }

    void remove() {
        this.fBrowserComponent.removeFocusListener(this.fFocusListener);
    }

    void addFocusChangeListener(HtmlDataListener<Boolean> htmlDataListener) {
        this.fFocusTracker.addFocusChangeListener(htmlDataListener);
    }

    private class JxBrowserFocusListener
    extends FocusAdapter {
        private JxBrowserFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JxBrowserFocusManager.this.fFocusTracker.requestNativeFocus();
        }
    }
}

