/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium.console;

import com.mathworks.html.jxbrowser.chromium.console.JavaScriptConsole;
import com.teamdev.jxbrowser.chromium.events.ConsoleEvent;
import java.text.SimpleDateFormat;
import java.util.Date;

enum ConsoleMessagePart {
    LEVEL("The level of the message - DEBUG, INFO, WARNING, ERROR"),
    LINE("The line number in the JavaScript source where the message occurred"),
    SOURCE("The source of the console message"),
    MESSAGE("The text of the console message"),
    TIMESTAMP("The time that the message occurred");

    private final String fDescription;

    private ConsoleMessagePart(String string2) {
        this.fDescription = string2;
    }

    String getDescription() {
        return this.fDescription;
    }

    String fromConsoleEvent(ConsoleEvent consoleEvent) {
        switch (this) {
            case LEVEL: {
                return JavaScriptConsole.adaptLevel(consoleEvent.getLevel()).toString();
            }
            case LINE: {
                return String.valueOf(consoleEvent.getLineNumber());
            }
            case SOURCE: {
                return consoleEvent.getSource();
            }
            case MESSAGE: {
                return consoleEvent.getMessage();
            }
            case TIMESTAMP: {
                return new SimpleDateFormat("YYYY-MM-dd HH:mm:ss:SSS").format(new Date());
            }
        }
        return "";
    }
}

