/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Window;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.quantum.GlassStage;

public class GlassWindowEventHandler
extends Window.EventHandler {
    private final GlassStage stage;

    public GlassWindowEventHandler(GlassStage glassStage) {
        this.stage = glassStage;
    }

    @Override
    public void handleWindowEvent(Window window, long l, int n) {
        if (this.stage == null || this.stage.stageListener == null) {
            return;
        }
        switch (n) {
            case 531: {
                this.stage.stageListener.changedIconified(true);
                break;
            }
            case 532: {
                break;
            }
            case 533: {
                this.stage.stageListener.changedIconified(false);
                break;
            }
            case 512: {
                this.stage.stageListener.changedLocation(window.getX(), window.getY());
                break;
            }
            case 511: {
                this.stage.stageListener.changedSize(window.getWidth(), window.getHeight());
                break;
            }
            case 542: {
                GlassStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.ACTIVATED);
                break;
            }
            case 541: {
                this.stage.stageListener.changedFocused(false, FocusCause.DEACTIVATED);
                break;
            }
            case 546: {
                this.stage.stageListener.focusUngrab();
                break;
            }
            case 543: {
                GlassStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_FORWARD);
                break;
            }
            case 544: {
                GlassStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_BACKWARD);
                break;
            }
            case 545: {
                this.stage.handleFocusDisabled();
                break;
            }
            case 522: {
                this.stage.setPlatformWindowClosed();
                this.stage.stageListener.closed();
                break;
            }
            case 521: {
                this.stage.stageListener.closing();
            }
        }
    }
}

