/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.demo;

import com.mathworks.mwswing.MJStartup;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class HComponentTester {
    private JFrame frame;
    private JButton button;
    private JLabel label;
    private JTextField textfield;
    private int button1ClickCount = 0;
    private int button2ClickCount = 0;
    private int button3ClickCount = 0;
    private int lastClickX = -1;
    private int lastClickY = -1;
    private int lastMoveX = -1;
    private int lastMoveY = -1;
    private int lastModifierMask;
    private int lastPressedKeyCode;
    private int lastReleasedKeyCode;
    JMenuItem menuitem1;
    JMenuItem menuitem2;
    JPopupMenu contextmenu;
    private BackgroundDraggablePanel dragPanel1;
    private BackgroundDraggablePanel dragPanel2;
    private Point lastDragStartPosition;
    private Point lastDragEndPosition;
    private JComponent lastDragStartComp;
    private JComponent lastDragEndComp;

    public HComponentTester() {
        MJStartup.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HComponentTester.this.createAndShowGUI();
            }
        });
    }

    private void createAndShowGUI() {
        this.frame = new JFrame("HComponentTester Frame");
        this.frame.setName("HComponentTesterFrame");
        this.frame.setDefaultCloseOperation(2);
        Container pane = this.frame.getContentPane();
        pane.setLayout(new GridLayout(5, 0));
        this.button = new JButton(){

            private int getPrivateInt(int x) {
                return x * x;
            }
        };
        this.button.setName("button");
        this.button.setToolTipText("buttonToolTip");
        this.button.putClientProperty("key", "value");
        pane.add(this.button);
        this.label = new JLabel("initial value");
        this.label.setName("label");
        pane.add(this.label);
        this.textfield = new JTextField();
        this.textfield.setName("textfield");
        pane.add(this.textfield);
        this.dragPanel1 = new BackgroundDraggablePanel();
        this.dragPanel1.setBackground(new Color(255, 0, 0));
        pane.add(this.dragPanel1);
        this.dragPanel2 = new BackgroundDraggablePanel();
        this.dragPanel2.setBackground(new Color(0, 0, 255));
        pane.add(this.dragPanel2);
        this.button.addMouseListener(new MyMouseListener());
        this.textfield.addMouseListener(new MyMouseListener());
        this.button.addMouseMotionListener(new MouseMoveListener());
        MyKeyListener keyListener = new MyKeyListener();
        this.textfield.addKeyListener(keyListener);
        this.button.addKeyListener(keyListener);
        this.initPopupMenu();
        this.frame.setLocation(100, 100);
        this.frame.setPreferredSize(new Dimension(300, 200));
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public static void main(String[] argv) {
        new HComponentTester();
    }

    public JButton getButton() {
        return this.button;
    }

    public JTextField getTextField() {
        return this.textfield;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JPopupMenu getPopupMenu() {
        return this.contextmenu;
    }

    public int getButton1ClickCount() {
        return this.button1ClickCount;
    }

    public int getButton2ClickCount() {
        return this.button2ClickCount;
    }

    public int getButton3ClickCount() {
        return this.button3ClickCount;
    }

    public int getLastClickX() {
        return this.lastClickX;
    }

    public int getLastClickY() {
        return this.lastClickY;
    }

    public int getLastMoveX() {
        return this.lastMoveX;
    }

    public int getLastMoveY() {
        return this.lastMoveY;
    }

    public int getLastPressedKeyCode() {
        return this.lastPressedKeyCode;
    }

    public int getLastReleasedKeyCode() {
        return this.lastReleasedKeyCode;
    }

    public int getLastModifierMask() {
        return this.lastModifierMask;
    }

    public Point getLastDragStartPosition() {
        return this.lastDragStartPosition;
    }

    public Point getLastDragEndPosition() {
        return this.lastDragEndPosition;
    }

    public JComponent getLastDragStartComponent() {
        return this.lastDragStartComp;
    }

    public JComponent getLastDragEndComponent() {
        return this.lastDragEndComp;
    }

    public JPanel getDragPanel1() {
        return this.dragPanel1;
    }

    public JPanel getDragPanel2() {
        return this.dragPanel2;
    }

    public void disableButton() {
        this.button.setEnabled(false);
    }

    public void hideFrame() {
        this.frame.setVisible(false);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void showFrame() {
        this.frame.setVisible(true);
    }

    public void initPopupMenu() {
        this.menuitem1 = new JMenuItem("menuitem1");
        this.menuitem1.setName("menuitem1Name");
        this.menuitem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMenuItem item = (JMenuItem)evt.getSource();
                HComponentTester.this.getLabel().setText(item.getText());
            }
        });
        this.menuitem2 = new JMenuItem("menuitem2");
        this.menuitem2.setName("menuitem2Name");
        this.menuitem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMenuItem item = (JMenuItem)evt.getSource();
                HComponentTester.this.getLabel().setText(item.getText());
            }
        });
        this.contextmenu = new JPopupMenu();
        this.contextmenu.add(this.menuitem1);
        this.contextmenu.add(this.menuitem2);
        this.contextmenu.setName("contextmenu");
        this.textfield.addMouseListener(new PopupListener(this.contextmenu));
    }

    class BackgroundDraggablePanel
    extends JPanel
    implements DragSourceListener,
    DragGestureListener,
    DropTargetListener {
        DragSource dragSource = new DragSource();
        DropTarget dropTarget = null;

        public BackgroundDraggablePanel() {
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.dropTarget = new DropTarget(this, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            HComponentTester.this.lastDragStartPosition = dge.getDragOrigin();
            HComponentTester.this.lastDragStartComp = this;
            StringSelection temp = new StringSelection("foo");
            this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, temp, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            HComponentTester.this.lastDragEndPosition = this.getMousePosition();
            HComponentTester.this.lastDragEndComp = this;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
                HComponentTester.this.lastClickX = e.getX();
                HComponentTester.this.lastClickY = e.getY();
            }
        }
    }

    class MouseMoveListener
    extends MouseMotionAdapter {
        MouseMoveListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            HComponentTester.this.lastMoveX = e.getX();
            HComponentTester.this.lastMoveY = e.getY();
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            HComponentTester.this.lastModifierMask = e.getModifiers();
            if (e.getButton() == 1) {
                HComponentTester.this.button1ClickCount += 1;
                HComponentTester.this.label.setText("post-click");
            } else if (e.getButton() == 2) {
                HComponentTester.this.button2ClickCount += 1;
            } else if (e.getButton() == 3) {
                HComponentTester.this.button3ClickCount += 1;
            }
            HComponentTester.this.lastClickX = e.getX();
            HComponentTester.this.lastClickY = e.getY();
        }
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            HComponentTester.this.lastPressedKeyCode = keyEvent.getKeyCode();
            HComponentTester.this.lastModifierMask = keyEvent.getModifiers();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            HComponentTester.this.lastReleasedKeyCode = keyEvent.getKeyCode();
        }
    }
}

