/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractTextComponentHandler;
import com.mathworks.matlabserver.jcp.utils.ImageUtils;
import com.mathworks.matlabserver.jcp.utils.MouseHandler;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.Point;
import java.util.Map;
import javax.swing.JLabel;

public class LabelHandler
extends AbstractTextComponentHandler {
    private Observer clickObserver;
    private MouseHandler mouseHandler;

    @Override
    public String getType() {
        return "Label";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        this.mouseHandler = new MouseHandler(component);
        super.handle(parentHandler, component, parentNode);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.clickObserver = new Observer(){

            public void handle(Event event) {
                LabelHandler.this.invokeLaterEDT(new Runnable(){

                    @Override
                    public void run() {
                        LabelHandler.this.mouseHandler.click(new Point(LabelHandler.this.component.getWidth() / 2, LabelHandler.this.component.getHeight() / 2));
                    }
                });
            }
        };
        this.peerNode.addPeerEventListener("clicked", this.clickObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removePeerEventListener("clicked", this.clickObserver);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            if (label.getIcon() != null) {
                props.put("icon", ImageUtils.getImageFromIcon(label.getIcon(), component));
            }
            props.put("iconTextGap", label.getIconTextGap());
        }
        return props;
    }
}

