/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.containerHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.containerHandlers.AbstractContainerHandler;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class AbstractTabContainerHandler
extends AbstractContainerHandler {
    private Observer peerEventListener = new Observer(){

        public void handle(final Event event) {
            if (event.getData().get("type").equals("closeTab")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTabContainerHandler.this.closeTab((int)((Double)event.getData().get("tabId")).doubleValue());
                    }
                });
            }
        }
    };
    private Observer propertySetListener = new Observer(){

        public void handle(final Event event) {
            String key = event.getData().get("key").toString();
            if (key.equals("selectedIndex")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTabContainerHandler.this.setSelectedIndex((int)((Double)event.getTarget().getProperty("selectedIndex")).doubleValue());
                    }
                });
            }
        }
    };
    private Observer childRemovedListener = new Observer(){

        public void handle(Event event) {
            event.getTarget().removeEventListener("peerEvent", AbstractTabContainerHandler.this.peerEventListener);
            event.getTarget().destroy();
        }
    };

    @Override
    public String getType() {
        return "TabContainer";
    }

    protected abstract void setSelectedIndex(int var1);

    protected void closeTab(int tabId) {
    }

    protected abstract int getChildContentPaneProperties(Component var1, Container var2, Map<String, Object> var3);

    protected abstract void getChildContentPaneProperties(int var1, Container var2, Map<String, Object> var3);

    protected abstract int getSelectedIndex();

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        super.handle(parentHandler, component, parent);
        this.peerNode.addEventListener("propertySet", this.propertySetListener);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        props.put("selectedIndex", this.getSelectedIndex());
        props.remove("background");
        if (this.getPeerNode() != null) {
            List children = this.getPeerNode().getChildren();
            for (int i = 0; i < children.size(); ++i) {
                HashMap<String, Object> tabProps = new HashMap<String, Object>();
                this.getChildContentPaneProperties(i, this.container, tabProps);
                ((PeerNode)children.get(i)).setProperties(tabProps);
            }
        }
        return props;
    }

    @Override
    protected void doAddChild(Component child, PeerNode peerNode, Container container) {
        HashMap<String, Object> tabProps = new HashMap<String, Object>();
        int i = this.getChildContentPaneProperties(child, container, tabProps);
        PeerNode childNode = peerNode.addChild("ContentPane", tabProps, i);
        childNode.addEventListener("peerEvent", this.peerEventListener);
        childNode.addEventListener("childRemoved", this.childRemovedListener);
        super.doAddChild(child, childNode, container);
    }
}

