/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.containerHandlers;

import com.mathworks.matlabserver.jcp.handlers.containerHandlers.AbstractTabContainerHandler;
import com.mathworks.matlabserver.jcp.utils.ReflectionUtils;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.widgets.desk.DTClient;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DTDocumentContainerHandler
extends AbstractTabContainerHandler
implements ItemListener,
PropertyChangeListener {
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String property = propertyChangeEvent.getPropertyName();
        if (property.equalsIgnoreCase("title") && this.peerNode.hasChildren()) {
            int i = 0;
            String ToolTip = null;
            List<DTClient> documents = this.getDocuments(this.container);
            for (DTClient client : documents) {
                if (client.getComponent() == propertyChangeEvent.getSource()) {
                    ToolTip = client.getTitle();
                    break;
                }
                ++i;
            }
            this.peerNode.getChild(i).setProperty("title", propertyChangeEvent.getNewValue());
            this.peerNode.getChild(i).setProperty("tooltip", (Object)ToolTip);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.markDirty();
    }

    @Override
    protected void doAddChild(Component child, PeerNode peerNode, Container container) {
        try {
            if (child.getClass().getName().equals("com.mathworks.widgets.desk.DTClientFrame")) {
                super.doAddChild(child, peerNode, container);
                ((ItemSelectable)((Object)child)).addItemListener(this);
                Method getOccupant = child.getClass().getDeclaredMethod("getOccupant", new Class[0]);
                getOccupant.setAccessible(true);
                Component component = ((DTClient)getOccupant.invoke((Object)child, new Object[0])).getComponent();
                component.addPropertyChangeListener(this);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    @Override
    protected void doRemoveChild(Component child) {
        try {
            if (child.getClass().getName().equals("com.mathworks.widgets.desk.DTClientFrame")) {
                super.doRemoveChild(child);
                ((ItemSelectable)((Object)child)).removeItemListener(this);
                Method getOccupant = child.getClass().getDeclaredMethod("getOccupant", new Class[0]);
                getOccupant.setAccessible(true);
                Component component = ((DTClient)getOccupant.invoke((Object)child, new Object[0])).getComponent();
                component.removePropertyChangeListener(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void addContainerListener(Container container) {
        Container pane = this.getMaximizedPane(container);
        if (pane != null) {
            super.addContainerListener(pane);
        }
    }

    @Override
    protected void removeContainerListener(Container container) {
        Container pane = this.getMaximizedPane(container);
        if (pane != null) {
            super.removeContainerListener(pane);
        }
    }

    @Override
    protected void setSelectedIndex(int tabId) {
        List<DTClient> documents = this.getDocuments(this.component);
        if (documents.size() > tabId) {
            documents.get(tabId).setSelected(true);
        }
    }

    @Override
    protected void closeTab(final int tabId) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List documents = DTDocumentContainerHandler.this.getDocuments(DTDocumentContainerHandler.this.component);
                if (documents.size() >= tabId) {
                    ((DTClient)documents.get(tabId)).close();
                }
            }
        });
    }

    @Override
    protected int getChildContentPaneProperties(Component child, Container container, Map<String, Object> tabProps) {
        try {
            List<DTClient> documents = this.getDocuments(container);
            if (child.getClass().getName().equals("com.mathworks.widgets.desk.DTClientFrame")) {
                Method getOccupant = child.getClass().getDeclaredMethod("getOccupant", new Class[0]);
                getOccupant.setAccessible(true);
                child = ((DTClient)getOccupant.invoke((Object)child, new Object[0])).getComponent();
            }
            int i = 0;
            for (DTClient client : documents) {
                if (client.getComponent() == child) {
                    this.getChildProps(client, tabProps);
                    return i;
                }
                ++i;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return 0;
    }

    @Override
    protected void getChildContentPaneProperties(int i, Container container, Map<String, Object> tabProps) {
        List<DTClient> documents = this.getDocuments(container);
        if (i >= 0 && i < documents.size()) {
            this.getChildProps(documents.get(i), tabProps);
        }
    }

    private void getChildProps(DTClient client, Map<String, Object> tabProps) {
        tabProps.put("title", client.getShortTitle());
        String tooltip = client.getTitle();
        if (tooltip != null) {
            tabProps.put("tooltip", tooltip);
        }
        tabProps.put("closable", true);
    }

    @Override
    protected int getSelectedIndex() {
        Container maxPane = this.getMaximizedPane(this.component);
        Object visibleClient = ReflectionUtils.getFieldValue(maxPane, "fVisibleDocument");
        List<DTClient> clients = this.getDocuments(this.component);
        for (int i = 0; i < clients.size(); ++i) {
            if (clients.get(i) != visibleClient) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected void processChildren(Container container) {
        for (Component child : this.getMaximizedPane(container).getComponents()) {
            this.doAddChild(child, this.peerNode, container);
        }
    }

    private Container getMaximizedPane(Component component) {
        Container maxPane = (Container)ReflectionUtils.getFieldValue(component, "fMaximizedPane");
        return maxPane == null ? (Container)component : maxPane;
    }

    private List<DTClient> getDocuments(Component component) {
        try {
            Method getDocuments = component.getClass().getDeclaredMethod("getDocuments", new Class[0]);
            getDocuments.setAccessible(true);
            return (List)getDocuments.invoke((Object)component, new Object[0]);
        }
        catch (Exception exception) {
            return new ArrayList<DTClient>();
        }
    }
}

